/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wisdom.model.HeadersCopier;
import software.amazon.awssdk.services.wisdom.model.WisdomResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartContentUploadResponse
extends WisdomResponse
implements ToCopyableBuilder<Builder, StartContentUploadResponse> {
    private static final SdkField<Map<String, String>> HEADERS_TO_INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("headersToInclude").getter(StartContentUploadResponse.getter(StartContentUploadResponse::headersToInclude)).setter(StartContentUploadResponse.setter(Builder::headersToInclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headersToInclude").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(StartContentUploadResponse.getter(StartContentUploadResponse::uploadId)).setter(StartContentUploadResponse.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(StartContentUploadResponse.getter(StartContentUploadResponse::url)).setter(StartContentUploadResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("urlExpiry").getter(StartContentUploadResponse.getter(StartContentUploadResponse::urlExpiry)).setter(StartContentUploadResponse.setter(Builder::urlExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_TO_INCLUDE_FIELD, UPLOAD_ID_FIELD, URL_FIELD, URL_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartContentUploadResponse.memberNameToFieldInitializer();
    private final Map<String, String> headersToInclude;
    private final String uploadId;
    private final String url;
    private final Instant urlExpiry;

    private StartContentUploadResponse(BuilderImpl builder) {
        super(builder);
        this.headersToInclude = builder.headersToInclude;
        this.uploadId = builder.uploadId;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    public final boolean hasHeadersToInclude() {
        return this.headersToInclude != null && !(this.headersToInclude instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headersToInclude() {
        return this.headersToInclude;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final String url() {
        return this.url;
    }

    public final Instant urlExpiry() {
        return this.urlExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeadersToInclude() ? this.headersToInclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContentUploadResponse)) {
            return false;
        }
        StartContentUploadResponse other = (StartContentUploadResponse)((Object)obj);
        return this.hasHeadersToInclude() == other.hasHeadersToInclude() && Objects.equals(this.headersToInclude(), other.headersToInclude()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.urlExpiry(), other.urlExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"StartContentUploadResponse").add("HeadersToInclude", this.hasHeadersToInclude() ? this.headersToInclude() : null).add("UploadId", (Object)this.uploadId()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("UrlExpiry", (Object)this.urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headersToInclude": {
                return Optional.ofNullable(clazz.cast(this.headersToInclude()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "urlExpiry": {
                return Optional.ofNullable(clazz.cast(this.urlExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("headersToInclude", HEADERS_TO_INCLUDE_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("url", URL_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContentUploadResponse, T> g) {
        return obj -> g.apply((StartContentUploadResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomResponse.BuilderImpl
    implements Builder {
        private Map<String, String> headersToInclude = DefaultSdkAutoConstructMap.getInstance();
        private String uploadId;
        private String url;
        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContentUploadResponse model) {
            super(model);
            this.headersToInclude(model.headersToInclude);
            this.uploadId(model.uploadId);
            this.url(model.url);
            this.urlExpiry(model.urlExpiry);
        }

        public final Map<String, String> getHeadersToInclude() {
            if (this.headersToInclude instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headersToInclude;
        }

        public final void setHeadersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = HeadersCopier.copy(headersToInclude);
        }

        @Override
        public final Builder headersToInclude(Map<String, String> headersToInclude) {
            this.headersToInclude = HeadersCopier.copy(headersToInclude);
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return this.urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        @Override
        public StartContentUploadResponse build() {
            return new StartContentUploadResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WisdomResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartContentUploadResponse> {
        public Builder headersToInclude(Map<String, String> var1);

        public Builder uploadId(String var1);

        public Builder url(String var1);

        public Builder urlExpiry(Instant var1);
    }
}

