/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wisdom.model.WisdomRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationsRequest
extends WisdomRequest
implements ToCopyableBuilder<Builder, GetRecommendationsRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::assistantId)).setter(GetRecommendationsRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::maxResults)).setter(GetRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::sessionId)).setter(GetRecommendationsRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<Integer> WAIT_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("waitTimeSeconds").getter(GetRecommendationsRequest.getter(GetRecommendationsRequest::waitTimeSeconds)).setter(GetRecommendationsRequest.setter(Builder::waitTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("waitTimeSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, MAX_RESULTS_FIELD, SESSION_ID_FIELD, WAIT_TIME_SECONDS_FIELD));
    private final String assistantId;
    private final Integer maxResults;
    private final String sessionId;
    private final Integer waitTimeSeconds;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.maxResults = builder.maxResults;
        this.sessionId = builder.sessionId;
        this.waitTimeSeconds = builder.waitTimeSeconds;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Integer waitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitTimeSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.waitTimeSeconds(), other.waitTimeSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationsRequest").add("AssistantId", (Object)this.assistantId()).add("MaxResults", (Object)this.maxResults()).add("SessionId", (Object)this.sessionId()).add("WaitTimeSeconds", (Object)this.waitTimeSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "waitTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitTimeSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WisdomRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private Integer maxResults;
        private String sessionId;
        private Integer waitTimeSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.maxResults(model.maxResults);
            this.sessionId(model.sessionId);
            this.waitTimeSeconds(model.waitTimeSeconds);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Integer getWaitTimeSeconds() {
            return this.waitTimeSeconds;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WisdomRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationsRequest> {
        public Builder assistantId(String var1);

        public Builder maxResults(Integer var1);

        public Builder sessionId(String var1);

        public Builder waitTimeSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

