/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.UpdateUserDetails;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(UpdateUserRequest.getter(UpdateUserRequest::networkId)).setter(UpdateUserRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<UpdateUserDetails> USER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userDetails").getter(UpdateUserRequest.getter(UpdateUserRequest::userDetails)).setter(UpdateUserRequest.setter(Builder::userDetails)).constructor(UpdateUserDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, USER_ID_FIELD, USER_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String userId;
    private final UpdateUserDetails userDetails;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.userId = builder.userId;
        this.userDetails = builder.userDetails;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String userId() {
        return this.userId;
    }

    public final UpdateUserDetails userDetails() {
        return this.userDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userDetails(), other.userDetails());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("NetworkId", (Object)this.networkId()).add("UserId", (Object)this.userId()).add("UserDetails", (Object)this.userDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userDetails": {
                return Optional.ofNullable(clazz.cast(this.userDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("userDetails", USER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String userId;
        private UpdateUserDetails userDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.userId(model.userId);
            this.userDetails(model.userDetails);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final UpdateUserDetails.Builder getUserDetails() {
            return this.userDetails != null ? this.userDetails.toBuilder() : null;
        }

        public final void setUserDetails(UpdateUserDetails.BuilderImpl userDetails) {
            this.userDetails = userDetails != null ? userDetails.build() : null;
        }

        @Override
        public final Builder userDetails(UpdateUserDetails userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder networkId(String var1);

        public Builder userId(String var1);

        public Builder userDetails(UpdateUserDetails var1);

        default public Builder userDetails(Consumer<UpdateUserDetails.Builder> userDetails) {
            return this.userDetails((UpdateUserDetails)((UpdateUserDetails.Builder)UpdateUserDetails.builder().applyMutation(userDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

