/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wickr.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(User.getter(User::userId)).setter(User.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firstName").getter(User.getter(User::firstName)).setter(User.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastName").getter(User.getter(User::lastName)).setter(User.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(User.getter(User::username)).setter(User.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroups").getter(User.getter(User::securityGroups)).setter(User.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ADMIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAdmin").getter(User.getter(User::isAdmin)).setter(User.setter(Builder::isAdmin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAdmin").build()}).build();
    private static final SdkField<Boolean> SUSPENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("suspended").getter(User.getter(User::suspended)).setter(User.setter(Builder::suspended)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suspended").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("status").getter(User.getter(User::status)).setter(User.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> OTP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("otpEnabled").getter(User.getter(User::otpEnabled)).setter(User.setter(Builder::otpEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otpEnabled").build()}).build();
    private static final SdkField<String> SCIM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scimId").getter(User.getter(User::scimId)).setter(User.setter(Builder::scimId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scimId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(User.getter(User::type)).setter(User.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CELL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cell").getter(User.getter(User::cell)).setter(User.setter(Builder::cell)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cell").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("countryCode").getter(User.getter(User::countryCode)).setter(User.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()}).build();
    private static final SdkField<Integer> CHALLENGE_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("challengeFailures").getter(User.getter(User::challengeFailures)).setter(User.setter(Builder::challengeFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challengeFailures").build()}).build();
    private static final SdkField<Boolean> IS_INVITE_EXPIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isInviteExpired").getter(User.getter(User::isInviteExpired)).setter(User.setter(Builder::isInviteExpired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInviteExpired").build()}).build();
    private static final SdkField<Boolean> IS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isUser").getter(User.getter(User::isUser)).setter(User.setter(Builder::isUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isUser").build()}).build();
    private static final SdkField<String> INVITE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inviteCode").getter(User.getter(User::inviteCode)).setter(User.setter(Builder::inviteCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inviteCode").build()}).build();
    private static final SdkField<Boolean> CODE_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("codeValidation").getter(User.getter(User::codeValidation)).setter(User.setter(Builder::codeValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeValidation").build()}).build();
    private static final SdkField<String> UNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uname").getter(User.getter(User::uname)).setter(User.setter(Builder::uname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uname").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, USERNAME_FIELD, SECURITY_GROUPS_FIELD, IS_ADMIN_FIELD, SUSPENDED_FIELD, STATUS_FIELD, OTP_ENABLED_FIELD, SCIM_ID_FIELD, TYPE_FIELD, CELL_FIELD, COUNTRY_CODE_FIELD, CHALLENGE_FAILURES_FIELD, IS_INVITE_EXPIRED_FIELD, IS_USER_FIELD, INVITE_CODE_FIELD, CODE_VALIDATION_FIELD, UNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = User.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String firstName;
    private final String lastName;
    private final String username;
    private final List<String> securityGroups;
    private final Boolean isAdmin;
    private final Boolean suspended;
    private final Integer status;
    private final Boolean otpEnabled;
    private final String scimId;
    private final String type;
    private final String cell;
    private final String countryCode;
    private final Integer challengeFailures;
    private final Boolean isInviteExpired;
    private final Boolean isUser;
    private final String inviteCode;
    private final Boolean codeValidation;
    private final String uname;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.securityGroups = builder.securityGroups;
        this.isAdmin = builder.isAdmin;
        this.suspended = builder.suspended;
        this.status = builder.status;
        this.otpEnabled = builder.otpEnabled;
        this.scimId = builder.scimId;
        this.type = builder.type;
        this.cell = builder.cell;
        this.countryCode = builder.countryCode;
        this.challengeFailures = builder.challengeFailures;
        this.isInviteExpired = builder.isInviteExpired;
        this.isUser = builder.isUser;
        this.inviteCode = builder.inviteCode;
        this.codeValidation = builder.codeValidation;
        this.uname = builder.uname;
    }

    public final String userId() {
        return this.userId;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final Boolean isAdmin() {
        return this.isAdmin;
    }

    public final Boolean suspended() {
        return this.suspended;
    }

    public final Integer status() {
        return this.status;
    }

    public final Boolean otpEnabled() {
        return this.otpEnabled;
    }

    public final String scimId() {
        return this.scimId;
    }

    public final String type() {
        return this.type;
    }

    public final String cell() {
        return this.cell;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final Integer challengeFailures() {
        return this.challengeFailures;
    }

    public final Boolean isInviteExpired() {
        return this.isInviteExpired;
    }

    public final Boolean isUser() {
        return this.isUser;
    }

    public final String inviteCode() {
        return this.inviteCode;
    }

    public final Boolean codeValidation() {
        return this.codeValidation;
    }

    public final String uname() {
        return this.uname;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isAdmin());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspended());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.otpEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.scimId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.cell());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.isInviteExpired());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeValidation());
        hashCode = 31 * hashCode + Objects.hashCode(this.uname());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.username(), other.username()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.isAdmin(), other.isAdmin()) && Objects.equals(this.suspended(), other.suspended()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.otpEnabled(), other.otpEnabled()) && Objects.equals(this.scimId(), other.scimId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.cell(), other.cell()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.challengeFailures(), other.challengeFailures()) && Objects.equals(this.isInviteExpired(), other.isInviteExpired()) && Objects.equals(this.isUser(), other.isUser()) && Objects.equals(this.inviteCode(), other.inviteCode()) && Objects.equals(this.codeValidation(), other.codeValidation()) && Objects.equals(this.uname(), other.uname());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("UserId", (Object)this.userId()).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)this.username()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("IsAdmin", (Object)this.isAdmin()).add("Suspended", (Object)this.suspended()).add("Status", (Object)this.status()).add("OtpEnabled", (Object)this.otpEnabled()).add("ScimId", (Object)this.scimId()).add("Type", (Object)this.type()).add("Cell", (Object)this.cell()).add("CountryCode", (Object)this.countryCode()).add("ChallengeFailures", (Object)this.challengeFailures()).add("IsInviteExpired", (Object)this.isInviteExpired()).add("IsUser", (Object)this.isUser()).add("InviteCode", (Object)this.inviteCode()).add("CodeValidation", (Object)this.codeValidation()).add("Uname", (Object)this.uname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "firstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "lastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "securityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "isAdmin": {
                return Optional.ofNullable(clazz.cast(this.isAdmin()));
            }
            case "suspended": {
                return Optional.ofNullable(clazz.cast(this.suspended()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "otpEnabled": {
                return Optional.ofNullable(clazz.cast(this.otpEnabled()));
            }
            case "scimId": {
                return Optional.ofNullable(clazz.cast(this.scimId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "cell": {
                return Optional.ofNullable(clazz.cast(this.cell()));
            }
            case "countryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "challengeFailures": {
                return Optional.ofNullable(clazz.cast(this.challengeFailures()));
            }
            case "isInviteExpired": {
                return Optional.ofNullable(clazz.cast(this.isInviteExpired()));
            }
            case "isUser": {
                return Optional.ofNullable(clazz.cast(this.isUser()));
            }
            case "inviteCode": {
                return Optional.ofNullable(clazz.cast(this.inviteCode()));
            }
            case "codeValidation": {
                return Optional.ofNullable(clazz.cast(this.codeValidation()));
            }
            case "uname": {
                return Optional.ofNullable(clazz.cast(this.uname()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", USER_ID_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("username", USERNAME_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("isAdmin", IS_ADMIN_FIELD);
        map.put("suspended", SUSPENDED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("otpEnabled", OTP_ENABLED_FIELD);
        map.put("scimId", SCIM_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("cell", CELL_FIELD);
        map.put("countryCode", COUNTRY_CODE_FIELD);
        map.put("challengeFailures", CHALLENGE_FAILURES_FIELD);
        map.put("isInviteExpired", IS_INVITE_EXPIRED_FIELD);
        map.put("isUser", IS_USER_FIELD);
        map.put("inviteCode", INVITE_CODE_FIELD);
        map.put("codeValidation", CODE_VALIDATION_FIELD);
        map.put("uname", UNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String firstName;
        private String lastName;
        private String username;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean isAdmin;
        private Boolean suspended;
        private Integer status;
        private Boolean otpEnabled;
        private String scimId;
        private String type;
        private String cell;
        private String countryCode;
        private Integer challengeFailures;
        private Boolean isInviteExpired;
        private Boolean isUser;
        private String inviteCode;
        private Boolean codeValidation;
        private String uname;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.userId(model.userId);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.username(model.username);
            this.securityGroups(model.securityGroups);
            this.isAdmin(model.isAdmin);
            this.suspended(model.suspended);
            this.status(model.status);
            this.otpEnabled(model.otpEnabled);
            this.scimId(model.scimId);
            this.type(model.type);
            this.cell(model.cell);
            this.countryCode(model.countryCode);
            this.challengeFailures(model.challengeFailures);
            this.isInviteExpired(model.isInviteExpired);
            this.isUser(model.isUser);
            this.inviteCode(model.inviteCode);
            this.codeValidation(model.codeValidation);
            this.uname(model.uname);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Boolean getIsAdmin() {
            return this.isAdmin;
        }

        public final void setIsAdmin(Boolean isAdmin) {
            this.isAdmin = isAdmin;
        }

        @Override
        public final Builder isAdmin(Boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        public final Boolean getSuspended() {
            return this.suspended;
        }

        public final void setSuspended(Boolean suspended) {
            this.suspended = suspended;
        }

        @Override
        public final Builder suspended(Boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Boolean getOtpEnabled() {
            return this.otpEnabled;
        }

        public final void setOtpEnabled(Boolean otpEnabled) {
            this.otpEnabled = otpEnabled;
        }

        @Override
        public final Builder otpEnabled(Boolean otpEnabled) {
            this.otpEnabled = otpEnabled;
            return this;
        }

        public final String getScimId() {
            return this.scimId;
        }

        public final void setScimId(String scimId) {
            this.scimId = scimId;
        }

        @Override
        public final Builder scimId(String scimId) {
            this.scimId = scimId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCell() {
            return this.cell;
        }

        public final void setCell(String cell) {
            this.cell = cell;
        }

        @Override
        public final Builder cell(String cell) {
            this.cell = cell;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final Integer getChallengeFailures() {
            return this.challengeFailures;
        }

        public final void setChallengeFailures(Integer challengeFailures) {
            this.challengeFailures = challengeFailures;
        }

        @Override
        public final Builder challengeFailures(Integer challengeFailures) {
            this.challengeFailures = challengeFailures;
            return this;
        }

        public final Boolean getIsInviteExpired() {
            return this.isInviteExpired;
        }

        public final void setIsInviteExpired(Boolean isInviteExpired) {
            this.isInviteExpired = isInviteExpired;
        }

        @Override
        public final Builder isInviteExpired(Boolean isInviteExpired) {
            this.isInviteExpired = isInviteExpired;
            return this;
        }

        public final Boolean getIsUser() {
            return this.isUser;
        }

        public final void setIsUser(Boolean isUser) {
            this.isUser = isUser;
        }

        @Override
        public final Builder isUser(Boolean isUser) {
            this.isUser = isUser;
            return this;
        }

        public final String getInviteCode() {
            return this.inviteCode;
        }

        public final void setInviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
        }

        @Override
        public final Builder inviteCode(String inviteCode) {
            this.inviteCode = inviteCode;
            return this;
        }

        public final Boolean getCodeValidation() {
            return this.codeValidation;
        }

        public final void setCodeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
        }

        @Override
        public final Builder codeValidation(Boolean codeValidation) {
            this.codeValidation = codeValidation;
            return this;
        }

        public final String getUname() {
            return this.uname;
        }

        public final void setUname(String uname) {
            this.uname = uname;
        }

        @Override
        public final Builder uname(String uname) {
            this.uname = uname;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder userId(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder username(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder isAdmin(Boolean var1);

        public Builder suspended(Boolean var1);

        public Builder status(Integer var1);

        public Builder otpEnabled(Boolean var1);

        public Builder scimId(String var1);

        public Builder type(String var1);

        public Builder cell(String var1);

        public Builder countryCode(String var1);

        public Builder challengeFailures(Integer var1);

        public Builder isInviteExpired(Boolean var1);

        public Builder isUser(Boolean var1);

        public Builder inviteCode(String var1);

        public Builder codeValidation(Boolean var1);

        public Builder uname(String var1);
    }
}

