/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterOidcConfigTestRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, RegisterOidcConfigTestRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(RegisterOidcConfigTestRequest.getter(RegisterOidcConfigTestRequest::networkId)).setter(RegisterOidcConfigTestRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> EXTRA_AUTH_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("extraAuthParams").getter(RegisterOidcConfigTestRequest.getter(RegisterOidcConfigTestRequest::extraAuthParams)).setter(RegisterOidcConfigTestRequest.setter(Builder::extraAuthParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraAuthParams").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(RegisterOidcConfigTestRequest.getter(RegisterOidcConfigTestRequest::issuer)).setter(RegisterOidcConfigTestRequest.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scopes").getter(RegisterOidcConfigTestRequest.getter(RegisterOidcConfigTestRequest::scopes)).setter(RegisterOidcConfigTestRequest.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificate").getter(RegisterOidcConfigTestRequest.getter(RegisterOidcConfigTestRequest::certificate)).setter(RegisterOidcConfigTestRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, EXTRA_AUTH_PARAMS_FIELD, ISSUER_FIELD, SCOPES_FIELD, CERTIFICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterOidcConfigTestRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String extraAuthParams;
    private final String issuer;
    private final String scopes;
    private final String certificate;

    private RegisterOidcConfigTestRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.extraAuthParams = builder.extraAuthParams;
        this.issuer = builder.issuer;
        this.scopes = builder.scopes;
        this.certificate = builder.certificate;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String extraAuthParams() {
        return this.extraAuthParams;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String scopes() {
        return this.scopes;
    }

    public final String certificate() {
        return this.certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraAuthParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopes());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOidcConfigTestRequest)) {
            return false;
        }
        RegisterOidcConfigTestRequest other = (RegisterOidcConfigTestRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.extraAuthParams(), other.extraAuthParams()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.certificate(), other.certificate());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterOidcConfigTestRequest").add("NetworkId", (Object)this.networkId()).add("ExtraAuthParams", (Object)this.extraAuthParams()).add("Issuer", (Object)this.issuer()).add("Scopes", (Object)this.scopes()).add("Certificate", (Object)this.certificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "extraAuthParams": {
                return Optional.ofNullable(clazz.cast(this.extraAuthParams()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("extraAuthParams", EXTRA_AUTH_PARAMS_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("scopes", SCOPES_FIELD);
        map.put("certificate", CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterOidcConfigTestRequest, T> g) {
        return obj -> g.apply((RegisterOidcConfigTestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String extraAuthParams;
        private String issuer;
        private String scopes;
        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOidcConfigTestRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.extraAuthParams(model.extraAuthParams);
            this.issuer(model.issuer);
            this.scopes(model.scopes);
            this.certificate(model.certificate);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getExtraAuthParams() {
            return this.extraAuthParams;
        }

        public final void setExtraAuthParams(String extraAuthParams) {
            this.extraAuthParams = extraAuthParams;
        }

        @Override
        public final Builder extraAuthParams(String extraAuthParams) {
            this.extraAuthParams = extraAuthParams;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getScopes() {
            return this.scopes;
        }

        public final void setScopes(String scopes) {
            this.scopes = scopes;
        }

        @Override
        public final Builder scopes(String scopes) {
            this.scopes = scopes;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterOidcConfigTestRequest build() {
            return new RegisterOidcConfigTestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterOidcConfigTestRequest> {
        public Builder networkId(String var1);

        public Builder extraAuthParams(String var1);

        public Builder issuer(String var1);

        public Builder scopes(String var1);

        public Builder certificate(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

