/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wickr.model.WickrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSecurityGroupRequest
extends WickrRequest
implements ToCopyableBuilder<Builder, GetSecurityGroupRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkId").getter(GetSecurityGroupRequest.getter(GetSecurityGroupRequest::networkId)).setter(GetSecurityGroupRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(GetSecurityGroupRequest.getter(GetSecurityGroupRequest::groupId)).setter(GetSecurityGroupRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("groupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSecurityGroupRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String groupId;

    private GetSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.groupId = builder.groupId;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String groupId() {
        return this.groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecurityGroupRequest)) {
            return false;
        }
        GetSecurityGroupRequest other = (GetSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.groupId(), other.groupId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSecurityGroupRequest").add("NetworkId", (Object)this.networkId()).add("GroupId", (Object)this.groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSecurityGroupRequest, T> g) {
        return obj -> g.apply((GetSecurityGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WickrRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecurityGroupRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.groupId(model.groupId);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSecurityGroupRequest build() {
            return new GetSecurityGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WickrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSecurityGroupRequest> {
        public Builder networkId(String var1);

        public Builder groupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

