/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wickr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessLevel {
    STANDARD("STANDARD"),
    PREMIUM("PREMIUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessLevel> VALUE_MAP;
    private final String value;

    private AccessLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessLevel> knownValues() {
        EnumSet<AccessLevel> knownValues = EnumSet.allOf(AccessLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessLevel.class, AccessLevel::toString);
    }
}

