/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse;

public class ListWorkloadsPublisher
implements SdkPublisher<ListWorkloadsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListWorkloadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkloadsPublisher(WellArchitectedAsyncClient client, ListWorkloadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkloadsPublisher(WellArchitectedAsyncClient client, ListWorkloadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkloadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkloadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWorkloadsResponseFetcher
    implements AsyncPageFetcher<ListWorkloadsResponse> {
        private ListWorkloadsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkloadsResponse> nextPage(ListWorkloadsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadsPublisher.this.client.listWorkloads(ListWorkloadsPublisher.this.firstRequest);
            }
            return ListWorkloadsPublisher.this.client.listWorkloads((ListWorkloadsRequest)((Object)ListWorkloadsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

