/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateSummary;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplatesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewTemplatesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListReviewTemplatesResponse> {
    private static final SdkField<List<ReviewTemplateSummary>> REVIEW_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReviewTemplates").getter(ListReviewTemplatesResponse.getter(ListReviewTemplatesResponse::reviewTemplates)).setter(ListReviewTemplatesResponse.setter(Builder::reviewTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReviewTemplatesResponse.getter(ListReviewTemplatesResponse::nextToken)).setter(ListReviewTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEW_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReviewTemplatesResponse.memberNameToFieldInitializer();
    private final List<ReviewTemplateSummary> reviewTemplates;
    private final String nextToken;

    private ListReviewTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.reviewTemplates = builder.reviewTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReviewTemplates() {
        return this.reviewTemplates != null && !(this.reviewTemplates instanceof SdkAutoConstructList);
    }

    public final List<ReviewTemplateSummary> reviewTemplates() {
        return this.reviewTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReviewTemplates() ? this.reviewTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewTemplatesResponse)) {
            return false;
        }
        ListReviewTemplatesResponse other = (ListReviewTemplatesResponse)((Object)obj);
        return this.hasReviewTemplates() == other.hasReviewTemplates() && Objects.equals(this.reviewTemplates(), other.reviewTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReviewTemplatesResponse").add("ReviewTemplates", this.hasReviewTemplates() ? this.reviewTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReviewTemplates": {
                return Optional.ofNullable(clazz.cast(this.reviewTemplates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReviewTemplates", REVIEW_TEMPLATES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReviewTemplatesResponse, T> g) {
        return obj -> g.apply((ListReviewTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<ReviewTemplateSummary> reviewTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewTemplatesResponse model) {
            super(model);
            this.reviewTemplates(model.reviewTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<ReviewTemplateSummary.Builder> getReviewTemplates() {
            List<ReviewTemplateSummary.Builder> result = ReviewTemplatesCopier.copyToBuilder(this.reviewTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewTemplates(Collection<ReviewTemplateSummary.BuilderImpl> reviewTemplates) {
            this.reviewTemplates = ReviewTemplatesCopier.copyFromBuilder(reviewTemplates);
        }

        @Override
        public final Builder reviewTemplates(Collection<ReviewTemplateSummary> reviewTemplates) {
            this.reviewTemplates = ReviewTemplatesCopier.copy(reviewTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewTemplates(ReviewTemplateSummary ... reviewTemplates) {
            this.reviewTemplates(Arrays.asList(reviewTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewTemplates(Consumer<ReviewTemplateSummary.Builder> ... reviewTemplates) {
            this.reviewTemplates(Stream.of(reviewTemplates).map(c -> (ReviewTemplateSummary)((ReviewTemplateSummary.Builder)ReviewTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReviewTemplatesResponse build() {
            return new ListReviewTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReviewTemplatesResponse> {
        public Builder reviewTemplates(Collection<ReviewTemplateSummary> var1);

        public Builder reviewTemplates(ReviewTemplateSummary ... var1);

        public Builder reviewTemplates(Consumer<ReviewTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

