/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DefinitionType {
    WORKLOAD_METADATA("WORKLOAD_METADATA"),
    APP_REGISTRY("APP_REGISTRY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DefinitionType> VALUE_MAP;
    private final String value;

    private DefinitionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DefinitionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DefinitionType> knownValues() {
        EnumSet<DefinitionType> knownValues = EnumSet.allOf(DefinitionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DefinitionType.class, DefinitionType::toString);
    }
}

