/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse;

public class ListProfileSharesIterable
implements SdkIterable<ListProfileSharesResponse> {
    private final WellArchitectedClient client;
    private final ListProfileSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileSharesIterable(WellArchitectedClient client, ListProfileSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfileSharesResponseFetcher();
    }

    public Iterator<ListProfileSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfileSharesResponseFetcher
    implements SyncPageFetcher<ListProfileSharesResponse> {
        private ListProfileSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileSharesResponse nextPage(ListProfileSharesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileSharesIterable.this.client.listProfileShares(ListProfileSharesIterable.this.firstRequest);
            }
            return ListProfileSharesIterable.this.client.listProfileShares((ListProfileSharesRequest)((Object)ListProfileSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

