/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.LensShareSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.LensShareSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLensSharesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListLensSharesResponse> {
    private static final SdkField<List<LensShareSummary>> LENS_SHARE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensShareSummaries").getter(ListLensSharesResponse.getter(ListLensSharesResponse::lensShareSummaries)).setter(ListLensSharesResponse.setter(Builder::lensShareSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensShareSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LensShareSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLensSharesResponse.getter(ListLensSharesResponse::nextToken)).setter(ListLensSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_SHARE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLensSharesResponse.memberNameToFieldInitializer();
    private final List<LensShareSummary> lensShareSummaries;
    private final String nextToken;

    private ListLensSharesResponse(BuilderImpl builder) {
        super(builder);
        this.lensShareSummaries = builder.lensShareSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLensShareSummaries() {
        return this.lensShareSummaries != null && !(this.lensShareSummaries instanceof SdkAutoConstructList);
    }

    public final List<LensShareSummary> lensShareSummaries() {
        return this.lensShareSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensShareSummaries() ? this.lensShareSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensSharesResponse)) {
            return false;
        }
        ListLensSharesResponse other = (ListLensSharesResponse)((Object)obj);
        return this.hasLensShareSummaries() == other.hasLensShareSummaries() && Objects.equals(this.lensShareSummaries(), other.lensShareSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLensSharesResponse").add("LensShareSummaries", this.hasLensShareSummaries() ? this.lensShareSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensShareSummaries": {
                return Optional.ofNullable(clazz.cast(this.lensShareSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LensShareSummaries", LENS_SHARE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLensSharesResponse, T> g) {
        return obj -> g.apply((ListLensSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<LensShareSummary> lensShareSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensSharesResponse model) {
            super(model);
            this.lensShareSummaries(model.lensShareSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<LensShareSummary.Builder> getLensShareSummaries() {
            List<LensShareSummary.Builder> result = LensShareSummariesCopier.copyToBuilder(this.lensShareSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLensShareSummaries(Collection<LensShareSummary.BuilderImpl> lensShareSummaries) {
            this.lensShareSummaries = LensShareSummariesCopier.copyFromBuilder(lensShareSummaries);
        }

        @Override
        public final Builder lensShareSummaries(Collection<LensShareSummary> lensShareSummaries) {
            this.lensShareSummaries = LensShareSummariesCopier.copy(lensShareSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensShareSummaries(LensShareSummary ... lensShareSummaries) {
            this.lensShareSummaries(Arrays.asList(lensShareSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensShareSummaries(Consumer<LensShareSummary.Builder> ... lensShareSummaries) {
            this.lensShareSummaries(Stream.of(lensShareSummaries).map(c -> (LensShareSummary)((LensShareSummary.Builder)LensShareSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLensSharesResponse build() {
            return new ListLensSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLensSharesResponse> {
        public Builder lensShareSummaries(Collection<LensShareSummary> var1);

        public Builder lensShareSummaries(LensShareSummary ... var1);

        public Builder lensShareSummaries(Consumer<LensShareSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

