/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JiraConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JiraConfiguration> {
    private static final SdkField<String> JIRA_ISSUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JiraIssueUrl").getter(JiraConfiguration.getter(JiraConfiguration::jiraIssueUrl)).setter(JiraConfiguration.setter(Builder::jiraIssueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraIssueUrl").build()}).build();
    private static final SdkField<Instant> LAST_SYNCED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSyncedTime").getter(JiraConfiguration.getter(JiraConfiguration::lastSyncedTime)).setter(JiraConfiguration.setter(Builder::lastSyncedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JIRA_ISSUE_URL_FIELD, LAST_SYNCED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JiraConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jiraIssueUrl;
    private final Instant lastSyncedTime;

    private JiraConfiguration(BuilderImpl builder) {
        this.jiraIssueUrl = builder.jiraIssueUrl;
        this.lastSyncedTime = builder.lastSyncedTime;
    }

    public final String jiraIssueUrl() {
        return this.jiraIssueUrl;
    }

    public final Instant lastSyncedTime() {
        return this.lastSyncedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraIssueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraConfiguration)) {
            return false;
        }
        JiraConfiguration other = (JiraConfiguration)obj;
        return Objects.equals(this.jiraIssueUrl(), other.jiraIssueUrl()) && Objects.equals(this.lastSyncedTime(), other.lastSyncedTime());
    }

    public final String toString() {
        return ToString.builder((String)"JiraConfiguration").add("JiraIssueUrl", (Object)this.jiraIssueUrl()).add("LastSyncedTime", (Object)this.lastSyncedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JiraIssueUrl": {
                return Optional.ofNullable(clazz.cast(this.jiraIssueUrl()));
            }
            case "LastSyncedTime": {
                return Optional.ofNullable(clazz.cast(this.lastSyncedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JiraIssueUrl", JIRA_ISSUE_URL_FIELD);
        map.put("LastSyncedTime", LAST_SYNCED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JiraConfiguration, T> g) {
        return obj -> g.apply((JiraConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jiraIssueUrl;
        private Instant lastSyncedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JiraConfiguration model) {
            this.jiraIssueUrl(model.jiraIssueUrl);
            this.lastSyncedTime(model.lastSyncedTime);
        }

        public final String getJiraIssueUrl() {
            return this.jiraIssueUrl;
        }

        public final void setJiraIssueUrl(String jiraIssueUrl) {
            this.jiraIssueUrl = jiraIssueUrl;
        }

        @Override
        public final Builder jiraIssueUrl(String jiraIssueUrl) {
            this.jiraIssueUrl = jiraIssueUrl;
            return this;
        }

        public final Instant getLastSyncedTime() {
            return this.lastSyncedTime;
        }

        public final void setLastSyncedTime(Instant lastSyncedTime) {
            this.lastSyncedTime = lastSyncedTime;
        }

        @Override
        public final Builder lastSyncedTime(Instant lastSyncedTime) {
            this.lastSyncedTime = lastSyncedTime;
            return this;
        }

        public JiraConfiguration build() {
            return new JiraConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JiraConfiguration> {
        public Builder jiraIssueUrl(String var1);

        public Builder lastSyncedTime(Instant var1);
    }
}

