/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscoveryIntegrationStatus {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscoveryIntegrationStatus> VALUE_MAP;
    private final String value;

    private DiscoveryIntegrationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscoveryIntegrationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscoveryIntegrationStatus> knownValues() {
        EnumSet<DiscoveryIntegrationStatus> knownValues = EnumSet.allOf(DiscoveryIntegrationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscoveryIntegrationStatus.class, DiscoveryIntegrationStatus::toString);
    }
}

