/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.LensAliasesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateLensesRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, DisassociateLensesRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(DisassociateLensesRequest.getter(DisassociateLensesRequest::workloadId)).setter(DisassociateLensesRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<List<String>> LENS_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LensAliases").getter(DisassociateLensesRequest.getter(DisassociateLensesRequest::lensAliases)).setter(DisassociateLensesRequest.setter(Builder::lensAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_ALIASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateLensesRequest.memberNameToFieldInitializer();
    private final String workloadId;
    private final List<String> lensAliases;

    private DisassociateLensesRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAliases = builder.lensAliases;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final boolean hasLensAliases() {
        return this.lensAliases != null && !(this.lensAliases instanceof SdkAutoConstructList);
    }

    public final List<String> lensAliases() {
        return this.lensAliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLensAliases() ? this.lensAliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateLensesRequest)) {
            return false;
        }
        DisassociateLensesRequest other = (DisassociateLensesRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && this.hasLensAliases() == other.hasLensAliases() && Objects.equals(this.lensAliases(), other.lensAliases());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateLensesRequest").add("WorkloadId", (Object)this.workloadId()).add("LensAliases", this.hasLensAliases() ? this.lensAliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensAliases": {
                return Optional.ofNullable(clazz.cast(this.lensAliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("LensAliases", LENS_ALIASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateLensesRequest, T> g) {
        return obj -> g.apply((DisassociateLensesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private List<String> lensAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateLensesRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensAliases(model.lensAliases);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final Collection<String> getLensAliases() {
            if (this.lensAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lensAliases;
        }

        public final void setLensAliases(Collection<String> lensAliases) {
            this.lensAliases = LensAliasesCopier.copy(lensAliases);
        }

        @Override
        public final Builder lensAliases(Collection<String> lensAliases) {
            this.lensAliases = LensAliasesCopier.copy(lensAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensAliases(String ... lensAliases) {
            this.lensAliases(Arrays.asList(lensAliases));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateLensesRequest build() {
            return new DisassociateLensesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateLensesRequest> {
        public Builder workloadId(String var1);

        public Builder lensAliases(Collection<String> var1);

        public Builder lensAliases(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

