/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.AccountJiraIssueManagementStatus;
import software.amazon.awssdk.services.wellarchitected.model.IntegrationStatus;
import software.amazon.awssdk.services.wellarchitected.model.IssueManagementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountJiraConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountJiraConfigurationOutput> {
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationStatus").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::integrationStatusAsString)).setter(AccountJiraConfigurationOutput.setter(Builder::integrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationStatus").build()}).build();
    private static final SdkField<String> ISSUE_MANAGEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementStatus").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::issueManagementStatusAsString)).setter(AccountJiraConfigurationOutput.setter(Builder::issueManagementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementStatus").build()}).build();
    private static final SdkField<String> ISSUE_MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssueManagementType").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::issueManagementTypeAsString)).setter(AccountJiraConfigurationOutput.setter(Builder::issueManagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueManagementType").build()}).build();
    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdomain").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::subdomain)).setter(AccountJiraConfigurationOutput.setter(Builder::subdomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdomain").build()}).build();
    private static final SdkField<String> JIRA_PROJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JiraProjectKey").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::jiraProjectKey)).setter(AccountJiraConfigurationOutput.setter(Builder::jiraProjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraProjectKey").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(AccountJiraConfigurationOutput.getter(AccountJiraConfigurationOutput::statusMessage)).setter(AccountJiraConfigurationOutput.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_STATUS_FIELD, ISSUE_MANAGEMENT_STATUS_FIELD, ISSUE_MANAGEMENT_TYPE_FIELD, SUBDOMAIN_FIELD, JIRA_PROJECT_KEY_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountJiraConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String integrationStatus;
    private final String issueManagementStatus;
    private final String issueManagementType;
    private final String subdomain;
    private final String jiraProjectKey;
    private final String statusMessage;

    private AccountJiraConfigurationOutput(BuilderImpl builder) {
        this.integrationStatus = builder.integrationStatus;
        this.issueManagementStatus = builder.issueManagementStatus;
        this.issueManagementType = builder.issueManagementType;
        this.subdomain = builder.subdomain;
        this.jiraProjectKey = builder.jiraProjectKey;
        this.statusMessage = builder.statusMessage;
    }

    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(this.integrationStatus);
    }

    public final String integrationStatusAsString() {
        return this.integrationStatus;
    }

    public final AccountJiraIssueManagementStatus issueManagementStatus() {
        return AccountJiraIssueManagementStatus.fromValue(this.issueManagementStatus);
    }

    public final String issueManagementStatusAsString() {
        return this.issueManagementStatus;
    }

    public final IssueManagementType issueManagementType() {
        return IssueManagementType.fromValue(this.issueManagementType);
    }

    public final String issueManagementTypeAsString() {
        return this.issueManagementType;
    }

    public final String subdomain() {
        return this.subdomain;
    }

    public final String jiraProjectKey() {
        return this.jiraProjectKey;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueManagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraProjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountJiraConfigurationOutput)) {
            return false;
        }
        AccountJiraConfigurationOutput other = (AccountJiraConfigurationOutput)obj;
        return Objects.equals(this.integrationStatusAsString(), other.integrationStatusAsString()) && Objects.equals(this.issueManagementStatusAsString(), other.issueManagementStatusAsString()) && Objects.equals(this.issueManagementTypeAsString(), other.issueManagementTypeAsString()) && Objects.equals(this.subdomain(), other.subdomain()) && Objects.equals(this.jiraProjectKey(), other.jiraProjectKey()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"AccountJiraConfigurationOutput").add("IntegrationStatus", (Object)this.integrationStatusAsString()).add("IssueManagementStatus", (Object)this.issueManagementStatusAsString()).add("IssueManagementType", (Object)this.issueManagementTypeAsString()).add("Subdomain", (Object)this.subdomain()).add("JiraProjectKey", (Object)this.jiraProjectKey()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationStatus": {
                return Optional.ofNullable(clazz.cast(this.integrationStatusAsString()));
            }
            case "IssueManagementStatus": {
                return Optional.ofNullable(clazz.cast(this.issueManagementStatusAsString()));
            }
            case "IssueManagementType": {
                return Optional.ofNullable(clazz.cast(this.issueManagementTypeAsString()));
            }
            case "Subdomain": {
                return Optional.ofNullable(clazz.cast(this.subdomain()));
            }
            case "JiraProjectKey": {
                return Optional.ofNullable(clazz.cast(this.jiraProjectKey()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IntegrationStatus", INTEGRATION_STATUS_FIELD);
        map.put("IssueManagementStatus", ISSUE_MANAGEMENT_STATUS_FIELD);
        map.put("IssueManagementType", ISSUE_MANAGEMENT_TYPE_FIELD);
        map.put("Subdomain", SUBDOMAIN_FIELD);
        map.put("JiraProjectKey", JIRA_PROJECT_KEY_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountJiraConfigurationOutput, T> g) {
        return obj -> g.apply((AccountJiraConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String integrationStatus;
        private String issueManagementStatus;
        private String issueManagementType;
        private String subdomain;
        private String jiraProjectKey;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountJiraConfigurationOutput model) {
            this.integrationStatus(model.integrationStatus);
            this.issueManagementStatus(model.issueManagementStatus);
            this.issueManagementType(model.issueManagementType);
            this.subdomain(model.subdomain);
            this.jiraProjectKey(model.jiraProjectKey);
            this.statusMessage(model.statusMessage);
        }

        public final String getIntegrationStatus() {
            return this.integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        public final String getIssueManagementStatus() {
            return this.issueManagementStatus;
        }

        public final void setIssueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
        }

        @Override
        public final Builder issueManagementStatus(String issueManagementStatus) {
            this.issueManagementStatus = issueManagementStatus;
            return this;
        }

        @Override
        public final Builder issueManagementStatus(AccountJiraIssueManagementStatus issueManagementStatus) {
            this.issueManagementStatus(issueManagementStatus == null ? null : issueManagementStatus.toString());
            return this;
        }

        public final String getIssueManagementType() {
            return this.issueManagementType;
        }

        public final void setIssueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
        }

        @Override
        public final Builder issueManagementType(String issueManagementType) {
            this.issueManagementType = issueManagementType;
            return this;
        }

        @Override
        public final Builder issueManagementType(IssueManagementType issueManagementType) {
            this.issueManagementType(issueManagementType == null ? null : issueManagementType.toString());
            return this;
        }

        public final String getSubdomain() {
            return this.subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getJiraProjectKey() {
            return this.jiraProjectKey;
        }

        public final void setJiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
        }

        @Override
        public final Builder jiraProjectKey(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public AccountJiraConfigurationOutput build() {
            return new AccountJiraConfigurationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountJiraConfigurationOutput> {
        public Builder integrationStatus(String var1);

        public Builder integrationStatus(IntegrationStatus var1);

        public Builder issueManagementStatus(String var1);

        public Builder issueManagementStatus(AccountJiraIssueManagementStatus var1);

        public Builder issueManagementType(String var1);

        public Builder issueManagementType(IssueManagementType var1);

        public Builder subdomain(String var1);

        public Builder jiraProjectKey(String var1);

        public Builder statusMessage(String var1);
    }
}

