/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileSharesResponse;

public class ListProfileSharesPublisher
implements SdkPublisher<ListProfileSharesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListProfileSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProfileSharesPublisher(WellArchitectedAsyncClient client, ListProfileSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProfileSharesPublisher(WellArchitectedAsyncClient client, ListProfileSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProfileSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProfileSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProfileSharesResponseFetcher
    implements AsyncPageFetcher<ListProfileSharesResponse> {
        private ListProfileSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProfileSharesResponse> nextPage(ListProfileSharesResponse previousPage) {
            if (previousPage == null) {
                return ListProfileSharesPublisher.this.client.listProfileShares(ListProfileSharesPublisher.this.firstRequest);
            }
            return ListProfileSharesPublisher.this.client.listProfileShares((ListProfileSharesRequest)((Object)ListProfileSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

