/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.Workload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Milestone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Milestone> {
    private static final SdkField<Integer> MILESTONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MilestoneNumber").getter(Milestone.getter(Milestone::milestoneNumber)).setter(Milestone.setter(Builder::milestoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneNumber").build()}).build();
    private static final SdkField<String> MILESTONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MilestoneName").getter(Milestone.getter(Milestone::milestoneName)).setter(Milestone.setter(Builder::milestoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneName").build()}).build();
    private static final SdkField<Instant> RECORDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecordedAt").getter(Milestone.getter(Milestone::recordedAt)).setter(Milestone.setter(Builder::recordedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedAt").build()}).build();
    private static final SdkField<Workload> WORKLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Workload").getter(Milestone.getter(Milestone::workload)).setter(Milestone.setter(Builder::workload)).constructor(Workload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MILESTONE_NUMBER_FIELD, MILESTONE_NAME_FIELD, RECORDED_AT_FIELD, WORKLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer milestoneNumber;
    private final String milestoneName;
    private final Instant recordedAt;
    private final Workload workload;

    private Milestone(BuilderImpl builder) {
        this.milestoneNumber = builder.milestoneNumber;
        this.milestoneName = builder.milestoneName;
        this.recordedAt = builder.recordedAt;
        this.workload = builder.workload;
    }

    public final Integer milestoneNumber() {
        return this.milestoneNumber;
    }

    public final String milestoneName() {
        return this.milestoneName;
    }

    public final Instant recordedAt() {
        return this.recordedAt;
    }

    public final Workload workload() {
        return this.workload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.milestoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.workload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Milestone)) {
            return false;
        }
        Milestone other = (Milestone)obj;
        return Objects.equals(this.milestoneNumber(), other.milestoneNumber()) && Objects.equals(this.milestoneName(), other.milestoneName()) && Objects.equals(this.recordedAt(), other.recordedAt()) && Objects.equals(this.workload(), other.workload());
    }

    public final String toString() {
        return ToString.builder((String)"Milestone").add("MilestoneNumber", (Object)this.milestoneNumber()).add("MilestoneName", (Object)this.milestoneName()).add("RecordedAt", (Object)this.recordedAt()).add("Workload", (Object)this.workload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MilestoneNumber": {
                return Optional.ofNullable(clazz.cast(this.milestoneNumber()));
            }
            case "MilestoneName": {
                return Optional.ofNullable(clazz.cast(this.milestoneName()));
            }
            case "RecordedAt": {
                return Optional.ofNullable(clazz.cast(this.recordedAt()));
            }
            case "Workload": {
                return Optional.ofNullable(clazz.cast(this.workload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Milestone, T> g) {
        return obj -> g.apply((Milestone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer milestoneNumber;
        private String milestoneName;
        private Instant recordedAt;
        private Workload workload;

        private BuilderImpl() {
        }

        private BuilderImpl(Milestone model) {
            this.milestoneNumber(model.milestoneNumber);
            this.milestoneName(model.milestoneName);
            this.recordedAt(model.recordedAt);
            this.workload(model.workload);
        }

        public final Integer getMilestoneNumber() {
            return this.milestoneNumber;
        }

        public final void setMilestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
        }

        @Override
        public final Builder milestoneNumber(Integer milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public final String getMilestoneName() {
            return this.milestoneName;
        }

        public final void setMilestoneName(String milestoneName) {
            this.milestoneName = milestoneName;
        }

        @Override
        public final Builder milestoneName(String milestoneName) {
            this.milestoneName = milestoneName;
            return this;
        }

        public final Instant getRecordedAt() {
            return this.recordedAt;
        }

        public final void setRecordedAt(Instant recordedAt) {
            this.recordedAt = recordedAt;
        }

        @Override
        public final Builder recordedAt(Instant recordedAt) {
            this.recordedAt = recordedAt;
            return this;
        }

        public final Workload.Builder getWorkload() {
            return this.workload != null ? this.workload.toBuilder() : null;
        }

        public final void setWorkload(Workload.BuilderImpl workload) {
            this.workload = workload != null ? workload.build() : null;
        }

        @Override
        public final Builder workload(Workload workload) {
            this.workload = workload;
            return this;
        }

        public Milestone build() {
            return new Milestone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Milestone> {
        public Builder milestoneNumber(Integer var1);

        public Builder milestoneName(String var1);

        public Builder recordedAt(Instant var1);

        public Builder workload(Workload var1);

        default public Builder workload(Consumer<Workload.Builder> workload) {
            return this.workload((Workload)((Workload.Builder)Workload.builder().applyMutation(workload)).build());
        }
    }
}

