/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.RequestInspectionACFP;
import software.amazon.awssdk.services.wafv2.model.ResponseInspection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AWSManagedRulesACFPRuleSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AWSManagedRulesACFPRuleSet> {
    private static final SdkField<String> CREATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationPath").getter(AWSManagedRulesACFPRuleSet.getter(AWSManagedRulesACFPRuleSet::creationPath)).setter(AWSManagedRulesACFPRuleSet.setter(Builder::creationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationPath").build()}).build();
    private static final SdkField<String> REGISTRATION_PAGE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationPagePath").getter(AWSManagedRulesACFPRuleSet.getter(AWSManagedRulesACFPRuleSet::registrationPagePath)).setter(AWSManagedRulesACFPRuleSet.setter(Builder::registrationPagePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationPagePath").build()}).build();
    private static final SdkField<RequestInspectionACFP> REQUEST_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestInspection").getter(AWSManagedRulesACFPRuleSet.getter(AWSManagedRulesACFPRuleSet::requestInspection)).setter(AWSManagedRulesACFPRuleSet.setter(Builder::requestInspection)).constructor(RequestInspectionACFP::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestInspection").build()}).build();
    private static final SdkField<ResponseInspection> RESPONSE_INSPECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseInspection").getter(AWSManagedRulesACFPRuleSet.getter(AWSManagedRulesACFPRuleSet::responseInspection)).setter(AWSManagedRulesACFPRuleSet.setter(Builder::responseInspection)).constructor(ResponseInspection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseInspection").build()}).build();
    private static final SdkField<Boolean> ENABLE_REGEX_IN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableRegexInPath").getter(AWSManagedRulesACFPRuleSet.getter(AWSManagedRulesACFPRuleSet::enableRegexInPath)).setter(AWSManagedRulesACFPRuleSet.setter(Builder::enableRegexInPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableRegexInPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_PATH_FIELD, REGISTRATION_PAGE_PATH_FIELD, REQUEST_INSPECTION_FIELD, RESPONSE_INSPECTION_FIELD, ENABLE_REGEX_IN_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AWSManagedRulesACFPRuleSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String creationPath;
    private final String registrationPagePath;
    private final RequestInspectionACFP requestInspection;
    private final ResponseInspection responseInspection;
    private final Boolean enableRegexInPath;

    private AWSManagedRulesACFPRuleSet(BuilderImpl builder) {
        this.creationPath = builder.creationPath;
        this.registrationPagePath = builder.registrationPagePath;
        this.requestInspection = builder.requestInspection;
        this.responseInspection = builder.responseInspection;
        this.enableRegexInPath = builder.enableRegexInPath;
    }

    public final String creationPath() {
        return this.creationPath;
    }

    public final String registrationPagePath() {
        return this.registrationPagePath;
    }

    public final RequestInspectionACFP requestInspection() {
        return this.requestInspection;
    }

    public final ResponseInspection responseInspection() {
        return this.responseInspection;
    }

    public final Boolean enableRegexInPath() {
        return this.enableRegexInPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationPagePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestInspection());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseInspection());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableRegexInPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesACFPRuleSet)) {
            return false;
        }
        AWSManagedRulesACFPRuleSet other = (AWSManagedRulesACFPRuleSet)obj;
        return Objects.equals(this.creationPath(), other.creationPath()) && Objects.equals(this.registrationPagePath(), other.registrationPagePath()) && Objects.equals(this.requestInspection(), other.requestInspection()) && Objects.equals(this.responseInspection(), other.responseInspection()) && Objects.equals(this.enableRegexInPath(), other.enableRegexInPath());
    }

    public final String toString() {
        return ToString.builder((String)"AWSManagedRulesACFPRuleSet").add("CreationPath", (Object)this.creationPath()).add("RegistrationPagePath", (Object)this.registrationPagePath()).add("RequestInspection", (Object)this.requestInspection()).add("ResponseInspection", (Object)this.responseInspection()).add("EnableRegexInPath", (Object)this.enableRegexInPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationPath": {
                return Optional.ofNullable(clazz.cast(this.creationPath()));
            }
            case "RegistrationPagePath": {
                return Optional.ofNullable(clazz.cast(this.registrationPagePath()));
            }
            case "RequestInspection": {
                return Optional.ofNullable(clazz.cast(this.requestInspection()));
            }
            case "ResponseInspection": {
                return Optional.ofNullable(clazz.cast(this.responseInspection()));
            }
            case "EnableRegexInPath": {
                return Optional.ofNullable(clazz.cast(this.enableRegexInPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationPath", CREATION_PATH_FIELD);
        map.put("RegistrationPagePath", REGISTRATION_PAGE_PATH_FIELD);
        map.put("RequestInspection", REQUEST_INSPECTION_FIELD);
        map.put("ResponseInspection", RESPONSE_INSPECTION_FIELD);
        map.put("EnableRegexInPath", ENABLE_REGEX_IN_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesACFPRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesACFPRuleSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String creationPath;
        private String registrationPagePath;
        private RequestInspectionACFP requestInspection;
        private ResponseInspection responseInspection;
        private Boolean enableRegexInPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesACFPRuleSet model) {
            this.creationPath(model.creationPath);
            this.registrationPagePath(model.registrationPagePath);
            this.requestInspection(model.requestInspection);
            this.responseInspection(model.responseInspection);
            this.enableRegexInPath(model.enableRegexInPath);
        }

        public final String getCreationPath() {
            return this.creationPath;
        }

        public final void setCreationPath(String creationPath) {
            this.creationPath = creationPath;
        }

        @Override
        public final Builder creationPath(String creationPath) {
            this.creationPath = creationPath;
            return this;
        }

        public final String getRegistrationPagePath() {
            return this.registrationPagePath;
        }

        public final void setRegistrationPagePath(String registrationPagePath) {
            this.registrationPagePath = registrationPagePath;
        }

        @Override
        public final Builder registrationPagePath(String registrationPagePath) {
            this.registrationPagePath = registrationPagePath;
            return this;
        }

        public final RequestInspectionACFP.Builder getRequestInspection() {
            return this.requestInspection != null ? this.requestInspection.toBuilder() : null;
        }

        public final void setRequestInspection(RequestInspectionACFP.BuilderImpl requestInspection) {
            this.requestInspection = requestInspection != null ? requestInspection.build() : null;
        }

        @Override
        public final Builder requestInspection(RequestInspectionACFP requestInspection) {
            this.requestInspection = requestInspection;
            return this;
        }

        public final ResponseInspection.Builder getResponseInspection() {
            return this.responseInspection != null ? this.responseInspection.toBuilder() : null;
        }

        public final void setResponseInspection(ResponseInspection.BuilderImpl responseInspection) {
            this.responseInspection = responseInspection != null ? responseInspection.build() : null;
        }

        @Override
        public final Builder responseInspection(ResponseInspection responseInspection) {
            this.responseInspection = responseInspection;
            return this;
        }

        public final Boolean getEnableRegexInPath() {
            return this.enableRegexInPath;
        }

        public final void setEnableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
        }

        @Override
        public final Builder enableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
            return this;
        }

        public AWSManagedRulesACFPRuleSet build() {
            return new AWSManagedRulesACFPRuleSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AWSManagedRulesACFPRuleSet> {
        public Builder creationPath(String var1);

        public Builder registrationPagePath(String var1);

        public Builder requestInspection(RequestInspectionACFP var1);

        default public Builder requestInspection(Consumer<RequestInspectionACFP.Builder> requestInspection) {
            return this.requestInspection((RequestInspectionACFP)((RequestInspectionACFP.Builder)RequestInspectionACFP.builder().applyMutation(requestInspection)).build());
        }

        public Builder responseInspection(ResponseInspection var1);

        default public Builder responseInspection(Consumer<ResponseInspection.Builder> responseInspection) {
            return this.responseInspection((ResponseInspection)((ResponseInspection.Builder)ResponseInspection.builder().applyMutation(responseInspection)).build());
        }

        public Builder enableRegexInPath(Boolean var1);
    }
}

