/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PredicateType {
    IP_MATCH("IPMatch"),
    BYTE_MATCH("ByteMatch"),
    SQL_INJECTION_MATCH("SqlInjectionMatch"),
    GEO_MATCH("GeoMatch"),
    SIZE_CONSTRAINT("SizeConstraint"),
    XSS_MATCH("XssMatch"),
    REGEX_MATCH("RegexMatch"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PredicateType> VALUE_MAP;
    private final String value;

    private PredicateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PredicateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PredicateType> knownValues() {
        EnumSet<PredicateType> knownValues = EnumSet.allOf(PredicateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PredicateType.class, PredicateType::toString);
    }
}

