/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.TxtMethodConfig;
import software.amazon.awssdk.services.vpclattice.model.VerificationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainVerificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainVerificationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DomainVerificationSummary.getter(DomainVerificationSummary::id)).setter(DomainVerificationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DomainVerificationSummary.getter(DomainVerificationSummary::arn)).setter(DomainVerificationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DomainVerificationSummary.getter(DomainVerificationSummary::domainName)).setter(DomainVerificationSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DomainVerificationSummary.getter(DomainVerificationSummary::statusAsString)).setter(DomainVerificationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TxtMethodConfig> TXT_METHOD_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("txtMethodConfig").getter(DomainVerificationSummary.getter(DomainVerificationSummary::txtMethodConfig)).setter(DomainVerificationSummary.setter(Builder::txtMethodConfig)).constructor(TxtMethodConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("txtMethodConfig").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DomainVerificationSummary.getter(DomainVerificationSummary::createdAt)).setter(DomainVerificationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_VERIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastVerifiedTime").getter(DomainVerificationSummary.getter(DomainVerificationSummary::lastVerifiedTime)).setter(DomainVerificationSummary.setter(Builder::lastVerifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastVerifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DomainVerificationSummary.getter(DomainVerificationSummary::tags)).setter(DomainVerificationSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DOMAIN_NAME_FIELD, STATUS_FIELD, TXT_METHOD_CONFIG_FIELD, CREATED_AT_FIELD, LAST_VERIFIED_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DomainVerificationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String domainName;
    private final String status;
    private final TxtMethodConfig txtMethodConfig;
    private final Instant createdAt;
    private final Instant lastVerifiedTime;
    private final Map<String, String> tags;

    private DomainVerificationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.domainName = builder.domainName;
        this.status = builder.status;
        this.txtMethodConfig = builder.txtMethodConfig;
        this.createdAt = builder.createdAt;
        this.lastVerifiedTime = builder.lastVerifiedTime;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final VerificationStatus status() {
        return VerificationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TxtMethodConfig txtMethodConfig() {
        return this.txtMethodConfig;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.txtMethodConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastVerifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainVerificationSummary)) {
            return false;
        }
        DomainVerificationSummary other = (DomainVerificationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.txtMethodConfig(), other.txtMethodConfig()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastVerifiedTime(), other.lastVerifiedTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DomainVerificationSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("DomainName", (Object)this.domainName()).add("Status", (Object)this.statusAsString()).add("TxtMethodConfig", (Object)this.txtMethodConfig()).add("CreatedAt", (Object)this.createdAt()).add("LastVerifiedTime", (Object)this.lastVerifiedTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "txtMethodConfig": {
                return Optional.ofNullable(clazz.cast(this.txtMethodConfig()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastVerifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastVerifiedTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("txtMethodConfig", TXT_METHOD_CONFIG_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastVerifiedTime", LAST_VERIFIED_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainVerificationSummary, T> g) {
        return obj -> g.apply((DomainVerificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String domainName;
        private String status;
        private TxtMethodConfig txtMethodConfig;
        private Instant createdAt;
        private Instant lastVerifiedTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainVerificationSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.domainName(model.domainName);
            this.status(model.status);
            this.txtMethodConfig(model.txtMethodConfig);
            this.createdAt(model.createdAt);
            this.lastVerifiedTime(model.lastVerifiedTime);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TxtMethodConfig.Builder getTxtMethodConfig() {
            return this.txtMethodConfig != null ? this.txtMethodConfig.toBuilder() : null;
        }

        public final void setTxtMethodConfig(TxtMethodConfig.BuilderImpl txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig != null ? txtMethodConfig.build() : null;
        }

        @Override
        public final Builder txtMethodConfig(TxtMethodConfig txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastVerifiedTime() {
            return this.lastVerifiedTime;
        }

        public final void setLastVerifiedTime(Instant lastVerifiedTime) {
            this.lastVerifiedTime = lastVerifiedTime;
        }

        @Override
        public final Builder lastVerifiedTime(Instant lastVerifiedTime) {
            this.lastVerifiedTime = lastVerifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public DomainVerificationSummary build() {
            return new DomainVerificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainVerificationSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder domainName(String var1);

        public Builder status(String var1);

        public Builder status(VerificationStatus var1);

        public Builder txtMethodConfig(TxtMethodConfig var1);

        default public Builder txtMethodConfig(Consumer<TxtMethodConfig.Builder> txtMethodConfig) {
            return this.txtMethodConfig((TxtMethodConfig)((TxtMethodConfig.Builder)TxtMethodConfig.builder().applyMutation(txtMethodConfig)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastVerifiedTime(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

