/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.AuthType;
import software.amazon.awssdk.services.vpclattice.model.SharingConfig;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceNetworkRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, CreateServiceNetworkRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateServiceNetworkRequest.getter(CreateServiceNetworkRequest::clientToken)).setter(CreateServiceNetworkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateServiceNetworkRequest.getter(CreateServiceNetworkRequest::name)).setter(CreateServiceNetworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(CreateServiceNetworkRequest.getter(CreateServiceNetworkRequest::authTypeAsString)).setter(CreateServiceNetworkRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateServiceNetworkRequest.getter(CreateServiceNetworkRequest::tags)).setter(CreateServiceNetworkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SharingConfig> SHARING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharingConfig").getter(CreateServiceNetworkRequest.getter(CreateServiceNetworkRequest::sharingConfig)).setter(CreateServiceNetworkRequest.setter(Builder::sharingConfig)).constructor(SharingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, AUTH_TYPE_FIELD, TAGS_FIELD, SHARING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateServiceNetworkRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String name;
    private final String authType;
    private final Map<String, String> tags;
    private final SharingConfig sharingConfig;

    private CreateServiceNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.authType = builder.authType;
        this.tags = builder.tags;
        this.sharingConfig = builder.sharingConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final SharingConfig sharingConfig() {
        return this.sharingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkRequest)) {
            return false;
        }
        CreateServiceNetworkRequest other = (CreateServiceNetworkRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sharingConfig(), other.sharingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceNetworkRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("AuthType", (Object)this.authTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("SharingConfig", (Object)this.sharingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "sharingConfig": {
                return Optional.ofNullable(clazz.cast(this.sharingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("sharingConfig", SHARING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkRequest, T> g) {
        return obj -> g.apply((CreateServiceNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private String authType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private SharingConfig sharingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.authType(model.authType);
            this.tags(model.tags);
            this.sharingConfig(model.sharingConfig);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final SharingConfig.Builder getSharingConfig() {
            return this.sharingConfig != null ? this.sharingConfig.toBuilder() : null;
        }

        public final void setSharingConfig(SharingConfig.BuilderImpl sharingConfig) {
            this.sharingConfig = sharingConfig != null ? sharingConfig.build() : null;
        }

        @Override
        public final Builder sharingConfig(SharingConfig sharingConfig) {
            this.sharingConfig = sharingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceNetworkRequest build() {
            return new CreateServiceNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceNetworkRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder tags(Map<String, String> var1);

        public Builder sharingConfig(SharingConfig var1);

        default public Builder sharingConfig(Consumer<SharingConfig.Builder> sharingConfig) {
            return this.sharingConfig((SharingConfig)((SharingConfig.Builder)SharingConfig.builder().applyMutation(sharingConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

