/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.RuleAction;
import software.amazon.awssdk.services.vpclattice.model.RuleMatch;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIdentifier").getter(CreateRuleRequest.getter(CreateRuleRequest::serviceIdentifier)).setter(CreateRuleRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()}).build();
    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listenerIdentifier").getter(CreateRuleRequest.getter(CreateRuleRequest::listenerIdentifier)).setter(CreateRuleRequest.setter(Builder::listenerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRuleRequest.getter(CreateRuleRequest::name)).setter(CreateRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RuleMatch> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("match").getter(CreateRuleRequest.getter(CreateRuleRequest::match)).setter(CreateRuleRequest.setter(Builder::match)).constructor(RuleMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(CreateRuleRequest.getter(CreateRuleRequest::priority)).setter(CreateRuleRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<RuleAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(CreateRuleRequest.getter(CreateRuleRequest::action)).setter(CreateRuleRequest.setter(Builder::action)).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateRuleRequest.getter(CreateRuleRequest::clientToken)).setter(CreateRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRuleRequest.getter(CreateRuleRequest::tags)).setter(CreateRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IDENTIFIER_FIELD, LISTENER_IDENTIFIER_FIELD, NAME_FIELD, MATCH_FIELD, PRIORITY_FIELD, ACTION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRuleRequest.memberNameToFieldInitializer();
    private final String serviceIdentifier;
    private final String listenerIdentifier;
    private final String name;
    private final RuleMatch match;
    private final Integer priority;
    private final RuleAction action;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIdentifier = builder.serviceIdentifier;
        this.listenerIdentifier = builder.listenerIdentifier;
        this.name = builder.name;
        this.match = builder.match;
        this.priority = builder.priority;
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    public final String listenerIdentifier() {
        return this.listenerIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final RuleMatch match() {
        return this.match;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final RuleAction action() {
        return this.action;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        return Objects.equals(this.serviceIdentifier(), other.serviceIdentifier()) && Objects.equals(this.listenerIdentifier(), other.listenerIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.match(), other.match()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRuleRequest").add("ServiceIdentifier", (Object)this.serviceIdentifier()).add("ListenerIdentifier", (Object)this.listenerIdentifier()).add("Name", (Object)this.name()).add("Match", (Object)this.match()).add("Priority", (Object)this.priority()).add("Action", (Object)this.action()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
            case "listenerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.listenerIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
        map.put("listenerIdentifier", LISTENER_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("match", MATCH_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String serviceIdentifier;
        private String listenerIdentifier;
        private String name;
        private RuleMatch match;
        private Integer priority;
        private RuleAction action;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            this.serviceIdentifier(model.serviceIdentifier);
            this.listenerIdentifier(model.listenerIdentifier);
            this.name(model.name);
            this.match(model.match);
            this.priority(model.priority);
            this.action(model.action);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final String getListenerIdentifier() {
            return this.listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleMatch.Builder getMatch() {
            return this.match != null ? this.match.toBuilder() : null;
        }

        public final void setMatch(RuleMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(RuleMatch match) {
            this.match = match;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final RuleAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(RuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action = action;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder serviceIdentifier(String var1);

        public Builder listenerIdentifier(String var1);

        public Builder name(String var1);

        public Builder match(RuleMatch var1);

        default public Builder match(Consumer<RuleMatch.Builder> match) {
            return this.match((RuleMatch)((RuleMatch.Builder)RuleMatch.builder().applyMutation(match)).build());
        }

        public Builder priority(Integer var1);

        public Builder action(RuleAction var1);

        default public Builder action(Consumer<RuleAction.Builder> action) {
            return this.action((RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation(action)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

