/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.TargetSummary;

public class ListTargetsIterable
implements SdkIterable<ListTargetsResponse> {
    private final VpcLatticeClient client;
    private final ListTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetsIterable(VpcLatticeClient client, ListTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTargetsResponseFetcher();
    }

    public Iterator<ListTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TargetSummary> items() {
        Function<ListTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTargetsResponseFetcher
    implements SyncPageFetcher<ListTargetsResponse> {
        private ListTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTargetsResponse nextPage(ListTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsIterable.this.client.listTargets(ListTargetsIterable.this.firstRequest);
            }
            return ListTargetsIterable.this.client.listTargets((ListTargetsRequest)((Object)ListTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

