/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationSummary;

public class ListResourceConfigurationsPublisher
implements SdkPublisher<ListResourceConfigurationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListResourceConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceConfigurationsPublisher(VpcLatticeAsyncClient client, ListResourceConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceConfigurationsPublisher(VpcLatticeAsyncClient client, ListResourceConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceConfigurationSummary> items() {
        Function<ListResourceConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListResourceConfigurationsResponse> {
        private ListResourceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceConfigurationsResponse> nextPage(ListResourceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceConfigurationsPublisher.this.client.listResourceConfigurations(ListResourceConfigurationsPublisher.this.firstRequest);
            }
            return ListResourceConfigurationsPublisher.this.client.listResourceConfigurations((ListResourceConfigurationsRequest)((Object)ListResourceConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

