/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationSummary;

public class ListResourceConfigurationsIterable
implements SdkIterable<ListResourceConfigurationsResponse> {
    private final VpcLatticeClient client;
    private final ListResourceConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceConfigurationsIterable(VpcLatticeClient client, ListResourceConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceConfigurationsResponseFetcher();
    }

    public Iterator<ListResourceConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceConfigurationSummary> items() {
        Function<ListResourceConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceConfigurationsResponseFetcher
    implements SyncPageFetcher<ListResourceConfigurationsResponse> {
        private ListResourceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceConfigurationsResponse nextPage(ListResourceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceConfigurationsIterable.this.client.listResourceConfigurations(ListResourceConfigurationsIterable.this.firstRequest);
            }
            return ListResourceConfigurationsIterable.this.client.listResourceConfigurations((ListResourceConfigurationsRequest)((Object)ListResourceConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

