/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.DomainSummariesCopier;
import software.amazon.awssdk.services.voiceid.model.DomainSummary;
import software.amazon.awssdk.services.voiceid.model.VoiceIdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsResponse
extends VoiceIdResponse
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private static final SdkField<List<DomainSummary>> DOMAIN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainSummaries").getter(ListDomainsResponse.getter(ListDomainsResponse::domainSummaries)).setter(ListDomainsResponse.setter(Builder::domainSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDomainsResponse.getter(ListDomainsResponse::nextToken)).setter(ListDomainsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainSummary> domainSummaries;
    private final String nextToken;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainSummaries = builder.domainSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDomainSummaries() {
        return this.domainSummaries != null && !(this.domainSummaries instanceof SdkAutoConstructList);
    }

    public final List<DomainSummary> domainSummaries() {
        return this.domainSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainSummaries() ? this.domainSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        return this.hasDomainSummaries() == other.hasDomainSummaries() && Objects.equals(this.domainSummaries(), other.domainSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainsResponse").add("DomainSummaries", this.hasDomainSummaries() ? this.domainSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainSummaries": {
                return Optional.ofNullable(clazz.cast(this.domainSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsResponse, T> g) {
        return obj -> g.apply((ListDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdResponse.BuilderImpl
    implements Builder {
        private List<DomainSummary> domainSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            super(model);
            this.domainSummaries(model.domainSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DomainSummary.Builder> getDomainSummaries() {
            List<DomainSummary.Builder> result = DomainSummariesCopier.copyToBuilder(this.domainSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainSummaries(Collection<DomainSummary.BuilderImpl> domainSummaries) {
            this.domainSummaries = DomainSummariesCopier.copyFromBuilder(domainSummaries);
        }

        @Override
        public final Builder domainSummaries(Collection<DomainSummary> domainSummaries) {
            this.domainSummaries = DomainSummariesCopier.copy(domainSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainSummaries(DomainSummary ... domainSummaries) {
            this.domainSummaries(Arrays.asList(domainSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainSummaries(Consumer<DomainSummary.Builder> ... domainSummaries) {
            this.domainSummaries(Stream.of(domainSummaries).map(c -> (DomainSummary)((DomainSummary.Builder)DomainSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VoiceIdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domainSummaries(Collection<DomainSummary> var1);

        public Builder domainSummaries(DomainSummary ... var1);

        public Builder domainSummaries(Consumer<DomainSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

