/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.VoiceIdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWatchlistRequest
extends VoiceIdRequest
implements ToCopyableBuilder<Builder, DeleteWatchlistRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DeleteWatchlistRequest.getter(DeleteWatchlistRequest::domainId)).setter(DeleteWatchlistRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> WATCHLIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WatchlistId").getter(DeleteWatchlistRequest.getter(DeleteWatchlistRequest::watchlistId)).setter(DeleteWatchlistRequest.setter(Builder::watchlistId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, WATCHLIST_ID_FIELD));
    private final String domainId;
    private final String watchlistId;

    private DeleteWatchlistRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.watchlistId = builder.watchlistId;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String watchlistId() {
        return this.watchlistId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.watchlistId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWatchlistRequest)) {
            return false;
        }
        DeleteWatchlistRequest other = (DeleteWatchlistRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.watchlistId(), other.watchlistId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWatchlistRequest").add("DomainId", (Object)this.domainId()).add("WatchlistId", (Object)this.watchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "WatchlistId": {
                return Optional.ofNullable(clazz.cast(this.watchlistId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWatchlistRequest, T> g) {
        return obj -> g.apply((DeleteWatchlistRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VoiceIdRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String watchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWatchlistRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.watchlistId(model.watchlistId);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getWatchlistId() {
            return this.watchlistId;
        }

        public final void setWatchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
        }

        @Override
        public final Builder watchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWatchlistRequest build() {
            return new DeleteWatchlistRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VoiceIdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWatchlistRequest> {
        public Builder domainId(String var1);

        public Builder watchlistId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

