/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaDefinition> {
    private static final SdkField<String> CEDAR_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cedarJson").getter(SchemaDefinition.getter(SchemaDefinition::cedarJson)).setter(SchemaDefinition.setter(Builder::cedarJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cedarJson").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CEDAR_JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cedarJson;
    private final Type type;

    private SchemaDefinition(BuilderImpl builder) {
        this.cedarJson = builder.cedarJson;
        this.type = builder.type;
    }

    public final String cedarJson() {
        return this.cedarJson;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cedarJson());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        return Objects.equals(this.cedarJson(), other.cedarJson());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaDefinition").add("CedarJson", (Object)(this.cedarJson() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cedarJson": {
                return Optional.ofNullable(clazz.cast(this.cedarJson()));
            }
        }
        return Optional.empty();
    }

    public static SchemaDefinition fromCedarJson(String cedarJson) {
        return (SchemaDefinition)SchemaDefinition.builder().cedarJson(cedarJson).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("cedarJson", CEDAR_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CEDAR_JSON,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String cedarJson;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            this.cedarJson(model.cedarJson);
        }

        public final String getCedarJson() {
            return this.cedarJson;
        }

        public final void setCedarJson(String cedarJson) {
            String oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            this.handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
        }

        @Override
        public final Builder cedarJson(String cedarJson) {
            String oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            this.handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
            return this;
        }

        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaDefinition> {
        public Builder cedarJson(String var1);
    }
}

