/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpenIdIssuer {
    COGNITO("COGNITO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpenIdIssuer> VALUE_MAP;
    private final String value;

    private OpenIdIssuer(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpenIdIssuer fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpenIdIssuer> knownValues() {
        EnumSet<OpenIdIssuer> knownValues = EnumSet.allOf(OpenIdIssuer.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpenIdIssuer.class, OpenIdIssuer::toString);
    }
}

