/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.AccountRecommendationLifecycleSummary;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse;

public class ListOrganizationRecommendationAccountsIterable
implements SdkIterable<ListOrganizationRecommendationAccountsResponse> {
    private final TrustedAdvisorClient client;
    private final ListOrganizationRecommendationAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationRecommendationAccountsIterable(TrustedAdvisorClient client, ListOrganizationRecommendationAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationRecommendationAccountsResponseFetcher();
    }

    public Iterator<ListOrganizationRecommendationAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountRecommendationLifecycleSummary> accountRecommendationLifecycleSummaries() {
        Function<ListOrganizationRecommendationAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountRecommendationLifecycleSummaries() != null) {
                return response.accountRecommendationLifecycleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationRecommendationAccountsResponseFetcher
    implements SyncPageFetcher<ListOrganizationRecommendationAccountsResponse> {
        private ListOrganizationRecommendationAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationRecommendationAccountsResponse nextPage(ListOrganizationRecommendationAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationAccountsIterable.this.client.listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsIterable.this.firstRequest);
            }
            return ListOrganizationRecommendationAccountsIterable.this.client.listOrganizationRecommendationAccounts((ListOrganizationRecommendationAccountsRequest)((Object)ListOrganizationRecommendationAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

