/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.Term;
import software.amazon.awssdk.services.translate.model.TermListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppliedTerminology
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppliedTerminology> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppliedTerminology.getter(AppliedTerminology::name)).setter(AppliedTerminology.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Term>> TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Terms").getter(AppliedTerminology.getter(AppliedTerminology::terms)).setter(AppliedTerminology.setter(Builder::terms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Terms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Term::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TERMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<Term> terms;

    private AppliedTerminology(BuilderImpl builder) {
        this.name = builder.name;
        this.terms = builder.terms;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTerms() {
        return this.terms != null && !(this.terms instanceof SdkAutoConstructList);
    }

    public final List<Term> terms() {
        return this.terms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerms() ? this.terms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedTerminology)) {
            return false;
        }
        AppliedTerminology other = (AppliedTerminology)obj;
        return Objects.equals(this.name(), other.name()) && this.hasTerms() == other.hasTerms() && Objects.equals(this.terms(), other.terms());
    }

    public final String toString() {
        return ToString.builder((String)"AppliedTerminology").add("Name", (Object)this.name()).add("Terms", this.hasTerms() ? this.terms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Terms": {
                return Optional.ofNullable(clazz.cast(this.terms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppliedTerminology, T> g) {
        return obj -> g.apply((AppliedTerminology)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<Term> terms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedTerminology model) {
            this.name(model.name);
            this.terms(model.terms);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Term.Builder> getTerms() {
            List<Term.Builder> result = TermListCopier.copyToBuilder(this.terms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerms(Collection<Term.BuilderImpl> terms) {
            this.terms = TermListCopier.copyFromBuilder(terms);
        }

        @Override
        public final Builder terms(Collection<Term> terms) {
            this.terms = TermListCopier.copy(terms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(Term ... terms) {
            this.terms(Arrays.asList(terms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terms(Consumer<Term.Builder> ... terms) {
            this.terms(Stream.of(terms).map(c -> (Term)((Term.Builder)Term.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AppliedTerminology build() {
            return new AppliedTerminology(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppliedTerminology> {
        public Builder name(String var1);

        public Builder terms(Collection<Term> var1);

        public Builder terms(Term ... var1);

        public Builder terms(Consumer<Term.Builder> ... var1);
    }
}

