/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.TerminologyProperties;
import software.amazon.awssdk.services.translate.model.TerminologyPropertiesListCopier;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTerminologiesResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, ListTerminologiesResponse> {
    private static final SdkField<List<TerminologyProperties>> TERMINOLOGY_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminologyPropertiesList").getter(ListTerminologiesResponse.getter(ListTerminologiesResponse::terminologyPropertiesList)).setter(ListTerminologiesResponse.setter(Builder::terminologyPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TerminologyProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTerminologiesResponse.getter(ListTerminologiesResponse::nextToken)).setter(ListTerminologiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINOLOGY_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<TerminologyProperties> terminologyPropertiesList;
    private final String nextToken;

    private ListTerminologiesResponse(BuilderImpl builder) {
        super(builder);
        this.terminologyPropertiesList = builder.terminologyPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTerminologyPropertiesList() {
        return this.terminologyPropertiesList != null && !(this.terminologyPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<TerminologyProperties> terminologyPropertiesList() {
        return this.terminologyPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminologyPropertiesList() ? this.terminologyPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTerminologiesResponse)) {
            return false;
        }
        ListTerminologiesResponse other = (ListTerminologiesResponse)((Object)obj);
        return this.hasTerminologyPropertiesList() == other.hasTerminologyPropertiesList() && Objects.equals(this.terminologyPropertiesList(), other.terminologyPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTerminologiesResponse").add("TerminologyPropertiesList", this.hasTerminologyPropertiesList() ? this.terminologyPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminologyPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.terminologyPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTerminologiesResponse, T> g) {
        return obj -> g.apply((ListTerminologiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private List<TerminologyProperties> terminologyPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTerminologiesResponse model) {
            super(model);
            this.terminologyPropertiesList(model.terminologyPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<TerminologyProperties.Builder> getTerminologyPropertiesList() {
            List<TerminologyProperties.Builder> result = TerminologyPropertiesListCopier.copyToBuilder(this.terminologyPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerminologyPropertiesList(Collection<TerminologyProperties.BuilderImpl> terminologyPropertiesList) {
            this.terminologyPropertiesList = TerminologyPropertiesListCopier.copyFromBuilder(terminologyPropertiesList);
        }

        @Override
        @Transient
        public final Builder terminologyPropertiesList(Collection<TerminologyProperties> terminologyPropertiesList) {
            this.terminologyPropertiesList = TerminologyPropertiesListCopier.copy(terminologyPropertiesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terminologyPropertiesList(TerminologyProperties ... terminologyPropertiesList) {
            this.terminologyPropertiesList(Arrays.asList(terminologyPropertiesList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terminologyPropertiesList(Consumer<TerminologyProperties.Builder> ... terminologyPropertiesList) {
            this.terminologyPropertiesList(Stream.of(terminologyPropertiesList).map(c -> (TerminologyProperties)((TerminologyProperties.Builder)TerminologyProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTerminologiesResponse build() {
            return new ListTerminologiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTerminologiesResponse> {
        public Builder terminologyPropertiesList(Collection<TerminologyProperties> var1);

        public Builder terminologyPropertiesList(TerminologyProperties ... var1);

        public Builder terminologyPropertiesList(Consumer<TerminologyProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

