/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.transfer.TransferAsyncClient;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.waiters.DefaultTransferAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface TransferAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOffline(DescribeServerRequest describeServerRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOffline(Consumer<DescribeServerRequest.Builder> describeServerRequest) {
        return this.waitUntilServerOffline((DescribeServerRequest)((Object)((DescribeServerRequest.Builder)DescribeServerRequest.builder().applyMutation(describeServerRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOffline(DescribeServerRequest describeServerRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOffline(Consumer<DescribeServerRequest.Builder> describeServerRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilServerOffline((DescribeServerRequest)((Object)((DescribeServerRequest.Builder)DescribeServerRequest.builder().applyMutation(describeServerRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOnline(DescribeServerRequest describeServerRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOnline(Consumer<DescribeServerRequest.Builder> describeServerRequest) {
        return this.waitUntilServerOnline((DescribeServerRequest)((Object)((DescribeServerRequest.Builder)DescribeServerRequest.builder().applyMutation(describeServerRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOnline(DescribeServerRequest describeServerRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeServerResponse>> waitUntilServerOnline(Consumer<DescribeServerRequest.Builder> describeServerRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilServerOnline((DescribeServerRequest)((Object)((DescribeServerRequest.Builder)DescribeServerRequest.builder().applyMutation(describeServerRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultTransferAsyncWaiter.builder();
    }

    public static TransferAsyncWaiter create() {
        return DefaultTransferAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(TransferAsyncClient var1);

        public TransferAsyncWaiter build();
    }
}

