/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProviderDetails> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(IdentityProviderDetails.getter(IdentityProviderDetails::url)).setter(IdentityProviderDetails.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationRole").getter(IdentityProviderDetails.getter(IdentityProviderDetails::invocationRole)).setter(IdentityProviderDetails.setter(Builder::invocationRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(IdentityProviderDetails.getter(IdentityProviderDetails::directoryId)).setter(IdentityProviderDetails.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Function").getter(IdentityProviderDetails.getter(IdentityProviderDetails::function)).setter(IdentityProviderDetails.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<String> SFTP_AUTHENTICATION_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SftpAuthenticationMethods").getter(IdentityProviderDetails.getter(IdentityProviderDetails::sftpAuthenticationMethodsAsString)).setter(IdentityProviderDetails.setter(Builder::sftpAuthenticationMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SftpAuthenticationMethods").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, INVOCATION_ROLE_FIELD, DIRECTORY_ID_FIELD, FUNCTION_FIELD, SFTP_AUTHENTICATION_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityProviderDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String invocationRole;
    private final String directoryId;
    private final String function;
    private final String sftpAuthenticationMethods;

    private IdentityProviderDetails(BuilderImpl builder) {
        this.url = builder.url;
        this.invocationRole = builder.invocationRole;
        this.directoryId = builder.directoryId;
        this.function = builder.function;
        this.sftpAuthenticationMethods = builder.sftpAuthenticationMethods;
    }

    public final String url() {
        return this.url;
    }

    public final String invocationRole() {
        return this.invocationRole;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String function() {
        return this.function;
    }

    public final SftpAuthenticationMethods sftpAuthenticationMethods() {
        return SftpAuthenticationMethods.fromValue(this.sftpAuthenticationMethods);
    }

    public final String sftpAuthenticationMethodsAsString() {
        return this.sftpAuthenticationMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.sftpAuthenticationMethodsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderDetails)) {
            return false;
        }
        IdentityProviderDetails other = (IdentityProviderDetails)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.invocationRole(), other.invocationRole()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.function(), other.function()) && Objects.equals(this.sftpAuthenticationMethodsAsString(), other.sftpAuthenticationMethodsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityProviderDetails").add("Url", (Object)this.url()).add("InvocationRole", (Object)this.invocationRole()).add("DirectoryId", (Object)this.directoryId()).add("Function", (Object)this.function()).add("SftpAuthenticationMethods", (Object)this.sftpAuthenticationMethodsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "InvocationRole": {
                return Optional.ofNullable(clazz.cast(this.invocationRole()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "SftpAuthenticationMethods": {
                return Optional.ofNullable(clazz.cast(this.sftpAuthenticationMethodsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Url", URL_FIELD);
        map.put("InvocationRole", INVOCATION_ROLE_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("SftpAuthenticationMethods", SFTP_AUTHENTICATION_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderDetails, T> g) {
        return obj -> g.apply((IdentityProviderDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String invocationRole;
        private String directoryId;
        private String function;
        private String sftpAuthenticationMethods;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderDetails model) {
            this.url(model.url);
            this.invocationRole(model.invocationRole);
            this.directoryId(model.directoryId);
            this.function(model.function);
            this.sftpAuthenticationMethods(model.sftpAuthenticationMethods);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getInvocationRole() {
            return this.invocationRole;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final String getSftpAuthenticationMethods() {
            return this.sftpAuthenticationMethods;
        }

        public final void setSftpAuthenticationMethods(String sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods = sftpAuthenticationMethods;
        }

        @Override
        public final Builder sftpAuthenticationMethods(String sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods = sftpAuthenticationMethods;
            return this;
        }

        @Override
        public final Builder sftpAuthenticationMethods(SftpAuthenticationMethods sftpAuthenticationMethods) {
            this.sftpAuthenticationMethods(sftpAuthenticationMethods == null ? null : sftpAuthenticationMethods.toString());
            return this;
        }

        public IdentityProviderDetails build() {
            return new IdentityProviderDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProviderDetails> {
        public Builder url(String var1);

        public Builder invocationRole(String var1);

        public Builder directoryId(String var1);

        public Builder function(String var1);

        public Builder sftpAuthenticationMethods(String var1);

        public Builder sftpAuthenticationMethods(SftpAuthenticationMethods var1);
    }
}

