/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSshPublicKeyRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, ImportSshPublicKeyRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(ImportSshPublicKeyRequest.getter(ImportSshPublicKeyRequest::serverId)).setter(ImportSshPublicKeyRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshPublicKeyBody").getter(ImportSshPublicKeyRequest.getter(ImportSshPublicKeyRequest::sshPublicKeyBody)).setter(ImportSshPublicKeyRequest.setter(Builder::sshPublicKeyBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyBody").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(ImportSshPublicKeyRequest.getter(ImportSshPublicKeyRequest::userName)).setter(ImportSshPublicKeyRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, SSH_PUBLIC_KEY_BODY_FIELD, USER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportSshPublicKeyRequest.memberNameToFieldInitializer();
    private final String serverId;
    private final String sshPublicKeyBody;
    private final String userName;

    private ImportSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.userName = builder.userName;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String sshPublicKeyBody() {
        return this.sshPublicKeyBody;
    }

    public final String userName() {
        return this.userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSshPublicKeyRequest)) {
            return false;
        }
        ImportSshPublicKeyRequest other = (ImportSshPublicKeyRequest)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.sshPublicKeyBody(), other.sshPublicKeyBody()) && Objects.equals(this.userName(), other.userName());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSshPublicKeyRequest").add("ServerId", (Object)this.serverId()).add("SshPublicKeyBody", (Object)this.sshPublicKeyBody()).add("UserName", (Object)this.userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "SshPublicKeyBody": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyBody()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("SshPublicKeyBody", SSH_PUBLIC_KEY_BODY_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportSshPublicKeyRequest, T> g) {
        return obj -> g.apply((ImportSshPublicKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String serverId;
        private String sshPublicKeyBody;
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSshPublicKeyRequest model) {
            super(model);
            this.serverId(model.serverId);
            this.sshPublicKeyBody(model.sshPublicKeyBody);
            this.userName(model.userName);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getSshPublicKeyBody() {
            return this.sshPublicKeyBody;
        }

        public final void setSshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSshPublicKeyRequest build() {
            return new ImportSshPublicKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportSshPublicKeyRequest> {
        public Builder serverId(String var1);

        public Builder sshPublicKeyBody(String var1);

        public Builder userName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

