/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.ExecutionError;
import software.amazon.awssdk.services.transfer.model.WorkflowStepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionStepResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionStepResult> {
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepType").getter(ExecutionStepResult.getter(ExecutionStepResult::stepTypeAsString)).setter(ExecutionStepResult.setter(Builder::stepType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepType").build()}).build();
    private static final SdkField<String> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Outputs").getter(ExecutionStepResult.getter(ExecutionStepResult::outputs)).setter(ExecutionStepResult.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build()}).build();
    private static final SdkField<ExecutionError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(ExecutionStepResult.getter(ExecutionStepResult::error)).setter(ExecutionStepResult.setter(Builder::error)).constructor(ExecutionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TYPE_FIELD, OUTPUTS_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionStepResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stepType;
    private final String outputs;
    private final ExecutionError error;

    private ExecutionStepResult(BuilderImpl builder) {
        this.stepType = builder.stepType;
        this.outputs = builder.outputs;
        this.error = builder.error;
    }

    public final WorkflowStepType stepType() {
        return WorkflowStepType.fromValue(this.stepType);
    }

    public final String stepTypeAsString() {
        return this.stepType;
    }

    public final String outputs() {
        return this.outputs;
    }

    public final ExecutionError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStepResult)) {
            return false;
        }
        ExecutionStepResult other = (ExecutionStepResult)obj;
        return Objects.equals(this.stepTypeAsString(), other.stepTypeAsString()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionStepResult").add("StepType", (Object)this.stepTypeAsString()).add("Outputs", (Object)this.outputs()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepType": {
                return Optional.ofNullable(clazz.cast(this.stepTypeAsString()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StepType", STEP_TYPE_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStepResult, T> g) {
        return obj -> g.apply((ExecutionStepResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepType;
        private String outputs;
        private ExecutionError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStepResult model) {
            this.stepType(model.stepType);
            this.outputs(model.outputs);
            this.error(model.error);
        }

        public final String getStepType() {
            return this.stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(WorkflowStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getOutputs() {
            return this.outputs;
        }

        public final void setOutputs(String outputs) {
            this.outputs = outputs;
        }

        @Override
        public final Builder outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public final ExecutionError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ExecutionError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ExecutionError error) {
            this.error = error;
            return this;
        }

        public ExecutionStepResult build() {
            return new ExecutionStepResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionStepResult> {
        public Builder stepType(String var1);

        public Builder stepType(WorkflowStepType var1);

        public Builder outputs(String var1);

        public Builder error(ExecutionError var1);

        default public Builder error(Consumer<ExecutionError.Builder> error) {
            return this.error((ExecutionError)((ExecutionError.Builder)ExecutionError.builder().applyMutation(error)).build());
        }
    }
}

