/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomStepStatus {
    SUCCESS("SUCCESS"),
    FAILURE("FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomStepStatus> VALUE_MAP;
    private final String value;

    private CustomStepStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomStepStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomStepStatus> knownValues() {
        EnumSet<CustomStepStatus> knownValues = EnumSet.allOf(CustomStepStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomStepStatus.class, CustomStepStatus::toString);
    }
}

