/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedWebApp;
import software.amazon.awssdk.services.transfer.model.ListedWebAppsCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebAppsResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListWebAppsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWebAppsResponse.getter(ListWebAppsResponse::nextToken)).setter(ListWebAppsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListedWebApp>> WEB_APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WebApps").getter(ListWebAppsResponse.getter(ListWebAppsResponse::webApps)).setter(ListWebAppsResponse.setter(Builder::webApps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebApps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedWebApp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WEB_APPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWebAppsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListedWebApp> webApps;

    private ListWebAppsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webApps = builder.webApps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWebApps() {
        return this.webApps != null && !(this.webApps instanceof SdkAutoConstructList);
    }

    public final List<ListedWebApp> webApps() {
        return this.webApps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebApps() ? this.webApps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAppsResponse)) {
            return false;
        }
        ListWebAppsResponse other = (ListWebAppsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWebApps() == other.hasWebApps() && Objects.equals(this.webApps(), other.webApps());
    }

    public final String toString() {
        return ToString.builder((String)"ListWebAppsResponse").add("NextToken", (Object)this.nextToken()).add("WebApps", this.hasWebApps() ? this.webApps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WebApps": {
                return Optional.ofNullable(clazz.cast(this.webApps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WebApps", WEB_APPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWebAppsResponse, T> g) {
        return obj -> g.apply((ListWebAppsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListedWebApp> webApps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAppsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.webApps(model.webApps);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedWebApp.Builder> getWebApps() {
            List<ListedWebApp.Builder> result = ListedWebAppsCopier.copyToBuilder(this.webApps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebApps(Collection<ListedWebApp.BuilderImpl> webApps) {
            this.webApps = ListedWebAppsCopier.copyFromBuilder(webApps);
        }

        @Override
        public final Builder webApps(Collection<ListedWebApp> webApps) {
            this.webApps = ListedWebAppsCopier.copy(webApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webApps(ListedWebApp ... webApps) {
            this.webApps(Arrays.asList(webApps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webApps(Consumer<ListedWebApp.Builder> ... webApps) {
            this.webApps(Stream.of(webApps).map(c -> (ListedWebApp)((ListedWebApp.Builder)ListedWebApp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebAppsResponse build() {
            return new ListWebAppsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebAppsResponse> {
        public Builder nextToken(String var1);

        public Builder webApps(Collection<ListedWebApp> var1);

        public Builder webApps(ListedWebApp ... var1);

        public Builder webApps(Consumer<ListedWebApp.Builder> ... var1);
    }
}

