/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinitionsCopier;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeContext;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeEncryptionSettings;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeInputStream;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribePostStreamAnalyticsSettings;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeVocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MedicalScribeConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeConfigurationEvent>,
MedicalScribeInputStream {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::vocabularyName)).setter(MedicalScribeConfigurationEvent.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::vocabularyFilterName)).setter(MedicalScribeConfigurationEvent.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::vocabularyFilterMethodAsString)).setter(MedicalScribeConfigurationEvent.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAccessRoleArn").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::resourceAccessRoleArn)).setter(MedicalScribeConfigurationEvent.setter(Builder::resourceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build()}).build();
    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelDefinitions").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::channelDefinitions)).setter(MedicalScribeConfigurationEvent.setter(Builder::channelDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeChannelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MedicalScribeEncryptionSettings> ENCRYPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionSettings").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::encryptionSettings)).setter(MedicalScribeConfigurationEvent.setter(Builder::encryptionSettings)).constructor(MedicalScribeEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSettings").build()}).build();
    private static final SdkField<MedicalScribePostStreamAnalyticsSettings> POST_STREAM_ANALYTICS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostStreamAnalyticsSettings").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::postStreamAnalyticsSettings)).setter(MedicalScribeConfigurationEvent.setter(Builder::postStreamAnalyticsSettings)).constructor(MedicalScribePostStreamAnalyticsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsSettings").build()}).build();
    private static final SdkField<MedicalScribeContext> MEDICAL_SCRIBE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MedicalScribeContext").getter(MedicalScribeConfigurationEvent.getter(MedicalScribeConfigurationEvent::medicalScribeContext)).setter(MedicalScribeConfigurationEvent.setter(Builder::medicalScribeContext)).constructor(MedicalScribeContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD, CHANNEL_DEFINITIONS_FIELD, ENCRYPTION_SETTINGS_FIELD, POST_STREAM_ANALYTICS_SETTINGS_FIELD, MEDICAL_SCRIBE_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeConfigurationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vocabularyName;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final String resourceAccessRoleArn;
    private final List<MedicalScribeChannelDefinition> channelDefinitions;
    private final MedicalScribeEncryptionSettings encryptionSettings;
    private final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;
    private final MedicalScribeContext medicalScribeContext;

    protected MedicalScribeConfigurationEvent(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.channelDefinitions = builder.channelDefinitions;
        this.encryptionSettings = builder.encryptionSettings;
        this.postStreamAnalyticsSettings = builder.postStreamAnalyticsSettings;
        this.medicalScribeContext = builder.medicalScribeContext;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final MedicalScribeVocabularyFilterMethod vocabularyFilterMethod() {
        return MedicalScribeVocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final String resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }

    public final boolean hasChannelDefinitions() {
        return this.channelDefinitions != null && !(this.channelDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return this.channelDefinitions;
    }

    public final MedicalScribeEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings() {
        return this.postStreamAnalyticsSettings;
    }

    public final MedicalScribeContext medicalScribeContext() {
        return this.medicalScribeContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelDefinitions() ? this.channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.postStreamAnalyticsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeConfigurationEvent)) {
            return false;
        }
        MedicalScribeConfigurationEvent other = (MedicalScribeConfigurationEvent)obj;
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.resourceAccessRoleArn(), other.resourceAccessRoleArn()) && this.hasChannelDefinitions() == other.hasChannelDefinitions() && Objects.equals(this.channelDefinitions(), other.channelDefinitions()) && Objects.equals(this.encryptionSettings(), other.encryptionSettings()) && Objects.equals(this.postStreamAnalyticsSettings(), other.postStreamAnalyticsSettings()) && Objects.equals(this.medicalScribeContext(), other.medicalScribeContext());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeConfigurationEvent").add("VocabularyName", (Object)this.vocabularyName()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ResourceAccessRoleArn", (Object)this.resourceAccessRoleArn()).add("ChannelDefinitions", this.hasChannelDefinitions() ? this.channelDefinitions() : null).add("EncryptionSettings", (Object)this.encryptionSettings()).add("PostStreamAnalyticsSettings", (Object)this.postStreamAnalyticsSettings()).add("MedicalScribeContext", (Object)this.medicalScribeContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ResourceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRoleArn()));
            }
            case "ChannelDefinitions": {
                return Optional.ofNullable(clazz.cast(this.channelDefinitions()));
            }
            case "EncryptionSettings": {
                return Optional.ofNullable(clazz.cast(this.encryptionSettings()));
            }
            case "PostStreamAnalyticsSettings": {
                return Optional.ofNullable(clazz.cast(this.postStreamAnalyticsSettings()));
            }
            case "MedicalScribeContext": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeContext()));
            }
        }
        return Optional.empty();
    }

    public final MedicalScribeConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return (MedicalScribeConfigurationEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("EncryptionSettings", ENCRYPTION_SETTINGS_FIELD);
        map.put("PostStreamAnalyticsSettings", POST_STREAM_ANALYTICS_SETTINGS_FIELD);
        map.put("MedicalScribeContext", MEDICAL_SCRIBE_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeConfigurationEvent, T> g) {
        return obj -> g.apply((MedicalScribeConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    protected static class BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private String resourceAccessRoleArn;
        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();
        private MedicalScribeEncryptionSettings encryptionSettings;
        private MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;
        private MedicalScribeContext medicalScribeContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MedicalScribeConfigurationEvent model) {
            this.vocabularyName(model.vocabularyName);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.resourceAccessRoleArn(model.resourceAccessRoleArn);
            this.channelDefinitions(model.channelDefinitions);
            this.encryptionSettings(model.encryptionSettings);
            this.postStreamAnalyticsSettings(model.postStreamAnalyticsSettings);
            this.medicalScribeContext(model.medicalScribeContext);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return this.resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition ... channelDefinitions) {
            this.channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... channelDefinitions) {
            this.channelDefinitions(Stream.of(channelDefinitions).map(c -> (MedicalScribeChannelDefinition)((MedicalScribeChannelDefinition.Builder)MedicalScribeChannelDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MedicalScribeEncryptionSettings.Builder getEncryptionSettings() {
            return this.encryptionSettings != null ? this.encryptionSettings.toBuilder() : null;
        }

        public final void setEncryptionSettings(MedicalScribeEncryptionSettings.BuilderImpl encryptionSettings) {
            this.encryptionSettings = encryptionSettings != null ? encryptionSettings.build() : null;
        }

        @Override
        public final Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings) {
            this.encryptionSettings = encryptionSettings;
            return this;
        }

        public final MedicalScribePostStreamAnalyticsSettings.Builder getPostStreamAnalyticsSettings() {
            return this.postStreamAnalyticsSettings != null ? this.postStreamAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings.BuilderImpl postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings;
            return this;
        }

        public final MedicalScribeContext.Builder getMedicalScribeContext() {
            return this.medicalScribeContext != null ? this.medicalScribeContext.toBuilder() : null;
        }

        public final void setMedicalScribeContext(MedicalScribeContext.BuilderImpl medicalScribeContext) {
            this.medicalScribeContext = medicalScribeContext != null ? medicalScribeContext.build() : null;
        }

        @Override
        public final Builder medicalScribeContext(MedicalScribeContext medicalScribeContext) {
            this.medicalScribeContext = medicalScribeContext;
            return this;
        }

        public MedicalScribeConfigurationEvent build() {
            return new MedicalScribeConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeConfigurationEvent> {
        public Builder vocabularyName(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod var1);

        public Builder resourceAccessRoleArn(String var1);

        public Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> var1);

        public Builder channelDefinitions(MedicalScribeChannelDefinition ... var1);

        public Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder> ... var1);

        public Builder encryptionSettings(MedicalScribeEncryptionSettings var1);

        default public Builder encryptionSettings(Consumer<MedicalScribeEncryptionSettings.Builder> encryptionSettings) {
            return this.encryptionSettings((MedicalScribeEncryptionSettings)((MedicalScribeEncryptionSettings.Builder)MedicalScribeEncryptionSettings.builder().applyMutation(encryptionSettings)).build());
        }

        public Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings var1);

        default public Builder postStreamAnalyticsSettings(Consumer<MedicalScribePostStreamAnalyticsSettings.Builder> postStreamAnalyticsSettings) {
            return this.postStreamAnalyticsSettings((MedicalScribePostStreamAnalyticsSettings)((MedicalScribePostStreamAnalyticsSettings.Builder)MedicalScribePostStreamAnalyticsSettings.builder().applyMutation(postStreamAnalyticsSettings)).build());
        }

        public Builder medicalScribeContext(MedicalScribeContext var1);

        default public Builder medicalScribeContext(Consumer<MedicalScribeContext.Builder> medicalScribeContext) {
            return this.medicalScribeContext((MedicalScribeContext)((MedicalScribeContext.Builder)MedicalScribeContext.builder().applyMutation(medicalScribeContext)).build());
        }
    }
}

