/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transcribestreaming.endpoints.TranscribeStreamingEndpointParams;
import software.amazon.awssdk.services.transcribestreaming.endpoints.TranscribeStreamingEndpointProvider;
import software.amazon.awssdk.services.transcribestreaming.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.transcribestreaming.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.transcribestreaming.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultTranscribeStreamingEndpointProvider
implements TranscribeStreamingEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(TranscribeStreamingEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(TranscribeStreamingEndpointParams params, String region) {
        RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultTranscribeStreamingEndpointProvider.endpointRule5(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(TranscribeStreamingEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(TranscribeStreamingEndpointParams params, String region) {
        if (region != null) {
            return DefaultTranscribeStreamingEndpointProvider.endpointRule6(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(TranscribeStreamingEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule7(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultTranscribeStreamingEndpointProvider.endpointRule11(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultTranscribeStreamingEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://transcribestreaming." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule8(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://transcribestreaming-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule12(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://transcribestreaming-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultTranscribeStreamingEndpointProvider.endpointRule16(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(TranscribeStreamingEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://transcribestreaming." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

