/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Item
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Item> {
    private static final SdkField<Double> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartTime").getter(Item.getter(Item::startTime)).setter(Item.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Double> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndTime").getter(Item.getter(Item::endTime)).setter(Item.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Item.getter(Item::typeAsString)).setter(Item.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(Item.getter(Item::content)).setter(Item.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VocabularyFilterMatch").getter(Item.getter(Item::vocabularyFilterMatch)).setter(Item.setter(Builder::vocabularyFilterMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build()}).build();
    private static final SdkField<String> SPEAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Speaker").getter(Item.getter(Item::speaker)).setter(Item.setter(Builder::speaker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speaker").build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Confidence").getter(Item.getter(Item::confidence)).setter(Item.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Boolean> STABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Stable").getter(Item.getter(Item::stable)).setter(Item.setter(Builder::stable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, TYPE_FIELD, CONTENT_FIELD, VOCABULARY_FILTER_MATCH_FIELD, SPEAKER_FIELD, CONFIDENCE_FIELD, STABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Item.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double startTime;
    private final Double endTime;
    private final String type;
    private final String content;
    private final Boolean vocabularyFilterMatch;
    private final String speaker;
    private final Double confidence;
    private final Boolean stable;

    private Item(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.content = builder.content;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
        this.speaker = builder.speaker;
        this.confidence = builder.confidence;
        this.stable = builder.stable;
    }

    public final Double startTime() {
        return this.startTime;
    }

    public final Double endTime() {
        return this.endTime;
    }

    public final ItemType type() {
        return ItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String content() {
        return this.content;
    }

    public final Boolean vocabularyFilterMatch() {
        return this.vocabularyFilterMatch;
    }

    public final String speaker() {
        return this.speaker;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public final Boolean stable() {
        return this.stable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.speaker());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.stable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.vocabularyFilterMatch(), other.vocabularyFilterMatch()) && Objects.equals(this.speaker(), other.speaker()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.stable(), other.stable());
    }

    public final String toString() {
        return ToString.builder((String)"Item").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Type", (Object)this.typeAsString()).add("Content", (Object)this.content()).add("VocabularyFilterMatch", (Object)this.vocabularyFilterMatch()).add("Speaker", (Object)this.speaker()).add("Confidence", (Object)this.confidence()).add("Stable", (Object)this.stable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "VocabularyFilterMatch": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMatch()));
            }
            case "Speaker": {
                return Optional.ofNullable(clazz.cast(this.speaker()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Stable": {
                return Optional.ofNullable(clazz.cast(this.stable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("VocabularyFilterMatch", VOCABULARY_FILTER_MATCH_FIELD);
        map.put("Speaker", SPEAKER_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Stable", STABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double startTime;
        private Double endTime;
        private String type;
        private String content;
        private Boolean vocabularyFilterMatch;
        private String speaker;
        private Double confidence;
        private Boolean stable;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.type(model.type);
            this.content(model.content);
            this.vocabularyFilterMatch(model.vocabularyFilterMatch);
            this.speaker(model.speaker);
            this.confidence(model.confidence);
            this.stable(model.stable);
        }

        public final Double getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return this.vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public final String getSpeaker() {
            return this.speaker;
        }

        public final void setSpeaker(String speaker) {
            this.speaker = speaker;
        }

        @Override
        public final Builder speaker(String speaker) {
            this.speaker = speaker;
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Boolean getStable() {
            return this.stable;
        }

        public final void setStable(Boolean stable) {
            this.stable = stable;
        }

        @Override
        public final Builder stable(Boolean stable) {
            this.stable = stable;
            return this;
        }

        public Item build() {
            return new Item(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Item> {
        public Builder startTime(Double var1);

        public Builder endTime(Double var1);

        public Builder type(String var1);

        public Builder type(ItemType var1);

        public Builder content(String var1);

        public Builder vocabularyFilterMatch(Boolean var1);

        public Builder speaker(String var1);

        public Builder confidence(Double var1);

        public Builder stable(Boolean var1);
    }
}

