/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalScribeJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalScribeJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.waiters.TranscribeAsyncWaiter;
import software.amazon.awssdk.services.transcribe.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultTranscribeAsyncWaiter
implements TranscribeAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final TranscribeAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetCallAnalyticsJobResponse> callAnalyticsJobCompletedWaiter;
    private final AsyncWaiter<DescribeLanguageModelResponse> languageModelCompletedWaiter;
    private final AsyncWaiter<GetMedicalScribeJobResponse> medicalScribeJobCompletedWaiter;
    private final AsyncWaiter<GetMedicalTranscriptionJobResponse> medicalTranscriptionJobCompletedWaiter;
    private final AsyncWaiter<GetMedicalVocabularyResponse> medicalVocabularyReadyWaiter;
    private final AsyncWaiter<GetTranscriptionJobResponse> transcriptionJobCompletedWaiter;
    private final AsyncWaiter<GetVocabularyResponse> vocabularyReadyWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultTranscribeAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (TranscribeAsyncClient)TranscribeAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.callAnalyticsJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetCallAnalyticsJobResponse.class).acceptors(DefaultTranscribeAsyncWaiter.callAnalyticsJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.callAnalyticsJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.languageModelCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeLanguageModelResponse.class).acceptors(DefaultTranscribeAsyncWaiter.languageModelCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.languageModelCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.medicalScribeJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetMedicalScribeJobResponse.class).acceptors(DefaultTranscribeAsyncWaiter.medicalScribeJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.medicalScribeJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.medicalTranscriptionJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetMedicalTranscriptionJobResponse.class).acceptors(DefaultTranscribeAsyncWaiter.medicalTranscriptionJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.medicalTranscriptionJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.medicalVocabularyReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetMedicalVocabularyResponse.class).acceptors(DefaultTranscribeAsyncWaiter.medicalVocabularyReadyWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.medicalVocabularyReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.transcriptionJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetTranscriptionJobResponse.class).acceptors(DefaultTranscribeAsyncWaiter.transcriptionJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.transcriptionJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.vocabularyReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetVocabularyResponse.class).acceptors(DefaultTranscribeAsyncWaiter.vocabularyReadyWaiterAcceptors())).overrideConfiguration(DefaultTranscribeAsyncWaiter.vocabularyReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCallAnalyticsJobResponse>> waitUntilCallAnalyticsJobCompleted(GetCallAnalyticsJobRequest getCallAnalyticsJobRequest) {
        return this.callAnalyticsJobCompletedWaiter.runAsync(() -> this.client.getCallAnalyticsJob(this.applyWaitersUserAgent(getCallAnalyticsJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetCallAnalyticsJobResponse>> waitUntilCallAnalyticsJobCompleted(GetCallAnalyticsJobRequest getCallAnalyticsJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.callAnalyticsJobCompletedWaiter.runAsync(() -> this.client.getCallAnalyticsJob(this.applyWaitersUserAgent(getCallAnalyticsJobRequest)), DefaultTranscribeAsyncWaiter.callAnalyticsJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLanguageModelResponse>> waitUntilLanguageModelCompleted(DescribeLanguageModelRequest describeLanguageModelRequest) {
        return this.languageModelCompletedWaiter.runAsync(() -> this.client.describeLanguageModel(this.applyWaitersUserAgent(describeLanguageModelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeLanguageModelResponse>> waitUntilLanguageModelCompleted(DescribeLanguageModelRequest describeLanguageModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.languageModelCompletedWaiter.runAsync(() -> this.client.describeLanguageModel(this.applyWaitersUserAgent(describeLanguageModelRequest)), DefaultTranscribeAsyncWaiter.languageModelCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalScribeJobResponse>> waitUntilMedicalScribeJobCompleted(GetMedicalScribeJobRequest getMedicalScribeJobRequest) {
        return this.medicalScribeJobCompletedWaiter.runAsync(() -> this.client.getMedicalScribeJob(this.applyWaitersUserAgent(getMedicalScribeJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalScribeJobResponse>> waitUntilMedicalScribeJobCompleted(GetMedicalScribeJobRequest getMedicalScribeJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalScribeJobCompletedWaiter.runAsync(() -> this.client.getMedicalScribeJob(this.applyWaitersUserAgent(getMedicalScribeJobRequest)), DefaultTranscribeAsyncWaiter.medicalScribeJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalTranscriptionJobResponse>> waitUntilMedicalTranscriptionJobCompleted(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) {
        return this.medicalTranscriptionJobCompletedWaiter.runAsync(() -> this.client.getMedicalTranscriptionJob(this.applyWaitersUserAgent(getMedicalTranscriptionJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalTranscriptionJobResponse>> waitUntilMedicalTranscriptionJobCompleted(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalTranscriptionJobCompletedWaiter.runAsync(() -> this.client.getMedicalTranscriptionJob(this.applyWaitersUserAgent(getMedicalTranscriptionJobRequest)), DefaultTranscribeAsyncWaiter.medicalTranscriptionJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalVocabularyResponse>> waitUntilMedicalVocabularyReady(GetMedicalVocabularyRequest getMedicalVocabularyRequest) {
        return this.medicalVocabularyReadyWaiter.runAsync(() -> this.client.getMedicalVocabulary(this.applyWaitersUserAgent(getMedicalVocabularyRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetMedicalVocabularyResponse>> waitUntilMedicalVocabularyReady(GetMedicalVocabularyRequest getMedicalVocabularyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalVocabularyReadyWaiter.runAsync(() -> this.client.getMedicalVocabulary(this.applyWaitersUserAgent(getMedicalVocabularyRequest)), DefaultTranscribeAsyncWaiter.medicalVocabularyReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetTranscriptionJobResponse>> waitUntilTranscriptionJobCompleted(GetTranscriptionJobRequest getTranscriptionJobRequest) {
        return this.transcriptionJobCompletedWaiter.runAsync(() -> this.client.getTranscriptionJob(this.applyWaitersUserAgent(getTranscriptionJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetTranscriptionJobResponse>> waitUntilTranscriptionJobCompleted(GetTranscriptionJobRequest getTranscriptionJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transcriptionJobCompletedWaiter.runAsync(() -> this.client.getTranscriptionJob(this.applyWaitersUserAgent(getTranscriptionJobRequest)), DefaultTranscribeAsyncWaiter.transcriptionJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVocabularyResponse>> waitUntilVocabularyReady(GetVocabularyRequest getVocabularyRequest) {
        return this.vocabularyReadyWaiter.runAsync(() -> this.client.getVocabulary(this.applyWaitersUserAgent(getVocabularyRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVocabularyResponse>> waitUntilVocabularyReady(GetVocabularyRequest getVocabularyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vocabularyReadyWaiter.runAsync(() -> this.client.getVocabulary(this.applyWaitersUserAgent(getVocabularyRequest)), DefaultTranscribeAsyncWaiter.vocabularyReadyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetCallAnalyticsJobResponse>> callAnalyticsJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCallAnalyticsJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetCallAnalyticsJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CallAnalyticsJob").field("CallAnalyticsJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CallAnalyticsJob").field("CallAnalyticsJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (CallAnalyticsJob.CallAnalyticsJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLanguageModelResponse>> languageModelCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLanguageModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLanguageModelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LanguageModel").field("ModelStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LanguageModel").field("ModelStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (LanguageModel.ModelStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalScribeJobResponse>> medicalScribeJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalScribeJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalScribeJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalScribeJob").field("MedicalScribeJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalScribeJob").field("MedicalScribeJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MedicalScribeJob.MedicalScribeJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>> medicalTranscriptionJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalTranscriptionJob").field("TranscriptionJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalTranscriptionJob").field("TranscriptionJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MedicalTranscriptionJob.TranscriptionJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalVocabularyResponse>> medicalVocabularyReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalVocabularyResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalVocabularyResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (VocabularyState=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetTranscriptionJobResponse>> transcriptionJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetTranscriptionJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetTranscriptionJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("TranscriptionJob").field("TranscriptionJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("TranscriptionJob").field("TranscriptionJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (TranscriptionJob.TranscriptionJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVocabularyResponse>> vocabularyReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVocabularyResponse>> result = new ArrayList<WaiterAcceptor<? super GetVocabularyResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (VocabularyState=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration callAnalyticsJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration languageModelCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalScribeJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalTranscriptionJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalVocabularyReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration transcriptionJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vocabularyReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static TranscribeAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends TranscribeRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TranscribeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements TranscribeAsyncWaiter.Builder {
        private TranscribeAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public TranscribeAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public TranscribeAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public TranscribeAsyncWaiter.Builder client(TranscribeAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public TranscribeAsyncWaiter build() {
            return new DefaultTranscribeAsyncWaiter(this);
        }
    }
}

