/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelRequest;
import software.amazon.awssdk.services.transcribe.model.DescribeLanguageModelResponse;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetCallAnalyticsJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalScribeJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalScribeJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetMedicalVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobRequest;
import software.amazon.awssdk.services.transcribe.model.GetTranscriptionJobResponse;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyRequest;
import software.amazon.awssdk.services.transcribe.model.GetVocabularyResponse;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.waiters.TranscribeWaiter;
import software.amazon.awssdk.services.transcribe.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultTranscribeWaiter
implements TranscribeWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final TranscribeClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetCallAnalyticsJobResponse> callAnalyticsJobCompletedWaiter;
    private final Waiter<DescribeLanguageModelResponse> languageModelCompletedWaiter;
    private final Waiter<GetMedicalScribeJobResponse> medicalScribeJobCompletedWaiter;
    private final Waiter<GetMedicalTranscriptionJobResponse> medicalTranscriptionJobCompletedWaiter;
    private final Waiter<GetMedicalVocabularyResponse> medicalVocabularyReadyWaiter;
    private final Waiter<GetTranscriptionJobResponse> transcriptionJobCompletedWaiter;
    private final Waiter<GetVocabularyResponse> vocabularyReadyWaiter;

    private DefaultTranscribeWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (TranscribeClient)TranscribeClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.callAnalyticsJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetCallAnalyticsJobResponse.class).acceptors(DefaultTranscribeWaiter.callAnalyticsJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.callAnalyticsJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.languageModelCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeLanguageModelResponse.class).acceptors(DefaultTranscribeWaiter.languageModelCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.languageModelCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.medicalScribeJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetMedicalScribeJobResponse.class).acceptors(DefaultTranscribeWaiter.medicalScribeJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.medicalScribeJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.medicalTranscriptionJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetMedicalTranscriptionJobResponse.class).acceptors(DefaultTranscribeWaiter.medicalTranscriptionJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.medicalTranscriptionJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.medicalVocabularyReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetMedicalVocabularyResponse.class).acceptors(DefaultTranscribeWaiter.medicalVocabularyReadyWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.medicalVocabularyReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.transcriptionJobCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetTranscriptionJobResponse.class).acceptors(DefaultTranscribeWaiter.transcriptionJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.transcriptionJobCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.vocabularyReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetVocabularyResponse.class).acceptors(DefaultTranscribeWaiter.vocabularyReadyWaiterAcceptors())).overrideConfiguration(DefaultTranscribeWaiter.vocabularyReadyWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetCallAnalyticsJobResponse> waitUntilCallAnalyticsJobCompleted(GetCallAnalyticsJobRequest getCallAnalyticsJobRequest) {
        return this.callAnalyticsJobCompletedWaiter.run(() -> this.client.getCallAnalyticsJob(this.applyWaitersUserAgent(getCallAnalyticsJobRequest)));
    }

    @Override
    public WaiterResponse<GetCallAnalyticsJobResponse> waitUntilCallAnalyticsJobCompleted(GetCallAnalyticsJobRequest getCallAnalyticsJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.callAnalyticsJobCompletedWaiter.run(() -> this.client.getCallAnalyticsJob(this.applyWaitersUserAgent(getCallAnalyticsJobRequest)), DefaultTranscribeWaiter.callAnalyticsJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeLanguageModelResponse> waitUntilLanguageModelCompleted(DescribeLanguageModelRequest describeLanguageModelRequest) {
        return this.languageModelCompletedWaiter.run(() -> this.client.describeLanguageModel(this.applyWaitersUserAgent(describeLanguageModelRequest)));
    }

    @Override
    public WaiterResponse<DescribeLanguageModelResponse> waitUntilLanguageModelCompleted(DescribeLanguageModelRequest describeLanguageModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.languageModelCompletedWaiter.run(() -> this.client.describeLanguageModel(this.applyWaitersUserAgent(describeLanguageModelRequest)), DefaultTranscribeWaiter.languageModelCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetMedicalScribeJobResponse> waitUntilMedicalScribeJobCompleted(GetMedicalScribeJobRequest getMedicalScribeJobRequest) {
        return this.medicalScribeJobCompletedWaiter.run(() -> this.client.getMedicalScribeJob(this.applyWaitersUserAgent(getMedicalScribeJobRequest)));
    }

    @Override
    public WaiterResponse<GetMedicalScribeJobResponse> waitUntilMedicalScribeJobCompleted(GetMedicalScribeJobRequest getMedicalScribeJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalScribeJobCompletedWaiter.run(() -> this.client.getMedicalScribeJob(this.applyWaitersUserAgent(getMedicalScribeJobRequest)), DefaultTranscribeWaiter.medicalScribeJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetMedicalTranscriptionJobResponse> waitUntilMedicalTranscriptionJobCompleted(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest) {
        return this.medicalTranscriptionJobCompletedWaiter.run(() -> this.client.getMedicalTranscriptionJob(this.applyWaitersUserAgent(getMedicalTranscriptionJobRequest)));
    }

    @Override
    public WaiterResponse<GetMedicalTranscriptionJobResponse> waitUntilMedicalTranscriptionJobCompleted(GetMedicalTranscriptionJobRequest getMedicalTranscriptionJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalTranscriptionJobCompletedWaiter.run(() -> this.client.getMedicalTranscriptionJob(this.applyWaitersUserAgent(getMedicalTranscriptionJobRequest)), DefaultTranscribeWaiter.medicalTranscriptionJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetMedicalVocabularyResponse> waitUntilMedicalVocabularyReady(GetMedicalVocabularyRequest getMedicalVocabularyRequest) {
        return this.medicalVocabularyReadyWaiter.run(() -> this.client.getMedicalVocabulary(this.applyWaitersUserAgent(getMedicalVocabularyRequest)));
    }

    @Override
    public WaiterResponse<GetMedicalVocabularyResponse> waitUntilMedicalVocabularyReady(GetMedicalVocabularyRequest getMedicalVocabularyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.medicalVocabularyReadyWaiter.run(() -> this.client.getMedicalVocabulary(this.applyWaitersUserAgent(getMedicalVocabularyRequest)), DefaultTranscribeWaiter.medicalVocabularyReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetTranscriptionJobResponse> waitUntilTranscriptionJobCompleted(GetTranscriptionJobRequest getTranscriptionJobRequest) {
        return this.transcriptionJobCompletedWaiter.run(() -> this.client.getTranscriptionJob(this.applyWaitersUserAgent(getTranscriptionJobRequest)));
    }

    @Override
    public WaiterResponse<GetTranscriptionJobResponse> waitUntilTranscriptionJobCompleted(GetTranscriptionJobRequest getTranscriptionJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transcriptionJobCompletedWaiter.run(() -> this.client.getTranscriptionJob(this.applyWaitersUserAgent(getTranscriptionJobRequest)), DefaultTranscribeWaiter.transcriptionJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVocabularyResponse> waitUntilVocabularyReady(GetVocabularyRequest getVocabularyRequest) {
        return this.vocabularyReadyWaiter.run(() -> this.client.getVocabulary(this.applyWaitersUserAgent(getVocabularyRequest)));
    }

    @Override
    public WaiterResponse<GetVocabularyResponse> waitUntilVocabularyReady(GetVocabularyRequest getVocabularyRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vocabularyReadyWaiter.run(() -> this.client.getVocabulary(this.applyWaitersUserAgent(getVocabularyRequest)), DefaultTranscribeWaiter.vocabularyReadyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetCallAnalyticsJobResponse>> callAnalyticsJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCallAnalyticsJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetCallAnalyticsJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CallAnalyticsJob").field("CallAnalyticsJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("CallAnalyticsJob").field("CallAnalyticsJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (CallAnalyticsJob.CallAnalyticsJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeLanguageModelResponse>> languageModelCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeLanguageModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeLanguageModelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LanguageModel").field("ModelStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("LanguageModel").field("ModelStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (LanguageModel.ModelStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalScribeJobResponse>> medicalScribeJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalScribeJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalScribeJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalScribeJob").field("MedicalScribeJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalScribeJob").field("MedicalScribeJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MedicalScribeJob.MedicalScribeJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>> medicalTranscriptionJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalTranscriptionJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalTranscriptionJob").field("TranscriptionJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MedicalTranscriptionJob").field("TranscriptionJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MedicalTranscriptionJob.TranscriptionJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetMedicalVocabularyResponse>> medicalVocabularyReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetMedicalVocabularyResponse>> result = new ArrayList<WaiterAcceptor<? super GetMedicalVocabularyResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (VocabularyState=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetTranscriptionJobResponse>> transcriptionJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetTranscriptionJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetTranscriptionJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("TranscriptionJob").field("TranscriptionJobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("TranscriptionJob").field("TranscriptionJobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (TranscriptionJob.TranscriptionJobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVocabularyResponse>> vocabularyReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVocabularyResponse>> result = new ArrayList<WaiterAcceptor<? super GetVocabularyResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("VocabularyState").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (VocabularyState=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration callAnalyticsJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration languageModelCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalScribeJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalTranscriptionJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration medicalVocabularyReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration transcriptionJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vocabularyReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(180);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static TranscribeWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends TranscribeRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TranscribeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements TranscribeWaiter.Builder {
        private TranscribeClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public TranscribeWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public TranscribeWaiter.Builder client(TranscribeClient client) {
            this.client = client;
            return this;
        }

        @Override
        public TranscribeWaiter build() {
            return new DefaultTranscribeWaiter(this);
        }
    }
}

