/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Specialty {
    PRIMARYCARE("PRIMARYCARE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Specialty> VALUE_MAP;
    private final String value;

    private Specialty(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Specialty fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Specialty> knownValues() {
        EnumSet<Specialty> knownValues = EnumSet.allOf(Specialty.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Specialty.class, Specialty::toString);
    }
}

