/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.InputType;
import software.amazon.awssdk.services.transcribe.model.Rule;
import software.amazon.awssdk.services.transcribe.model.RuleListCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCallAnalyticsCategoryRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, UpdateCallAnalyticsCategoryRequest> {
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryName").getter(UpdateCallAnalyticsCategoryRequest.getter(UpdateCallAnalyticsCategoryRequest::categoryName)).setter(UpdateCallAnalyticsCategoryRequest.setter(Builder::categoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(UpdateCallAnalyticsCategoryRequest.getter(UpdateCallAnalyticsCategoryRequest::rules)).setter(UpdateCallAnalyticsCategoryRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(UpdateCallAnalyticsCategoryRequest.getter(UpdateCallAnalyticsCategoryRequest::inputTypeAsString)).setter(UpdateCallAnalyticsCategoryRequest.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_NAME_FIELD, RULES_FIELD, INPUT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCallAnalyticsCategoryRequest.memberNameToFieldInitializer();
    private final String categoryName;
    private final List<Rule> rules;
    private final String inputType;

    private UpdateCallAnalyticsCategoryRequest(BuilderImpl builder) {
        super(builder);
        this.categoryName = builder.categoryName;
        this.rules = builder.rules;
        this.inputType = builder.inputType;
    }

    public final String categoryName() {
        return this.categoryName;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final InputType inputType() {
        return InputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCallAnalyticsCategoryRequest)) {
            return false;
        }
        UpdateCallAnalyticsCategoryRequest other = (UpdateCallAnalyticsCategoryRequest)((Object)obj);
        return Objects.equals(this.categoryName(), other.categoryName()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCallAnalyticsCategoryRequest").add("CategoryName", (Object)this.categoryName()).add("Rules", this.hasRules() ? this.rules() : null).add("InputType", (Object)this.inputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryName": {
                return Optional.ofNullable(clazz.cast(this.categoryName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CategoryName", CATEGORY_NAME_FIELD);
        map.put("Rules", RULES_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCallAnalyticsCategoryRequest, T> g) {
        return obj -> g.apply((UpdateCallAnalyticsCategoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String categoryName;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private String inputType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCallAnalyticsCategoryRequest model) {
            super(model);
            this.categoryName(model.categoryName);
            this.rules(model.rules);
            this.inputType(model.inputType);
        }

        public final String getCategoryName() {
            return this.categoryName;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCallAnalyticsCategoryRequest build() {
            return new UpdateCallAnalyticsCategoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCallAnalyticsCategoryRequest> {
        public Builder categoryName(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder inputType(String var1);

        public Builder inputType(InputType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

