/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeJobStatus;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeLanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeJobSummary> {
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalScribeJobName").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::medicalScribeJobName)).setter(MedicalScribeJobSummary.setter(Builder::medicalScribeJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::creationTime)).setter(MedicalScribeJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::startTime)).setter(MedicalScribeJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::completionTime)).setter(MedicalScribeJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::languageCodeAsString)).setter(MedicalScribeJobSummary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> MEDICAL_SCRIBE_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MedicalScribeJobStatus").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::medicalScribeJobStatusAsString)).setter(MedicalScribeJobSummary.setter(Builder::medicalScribeJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MedicalScribeJobSummary.getter(MedicalScribeJobSummary::failureReason)).setter(MedicalScribeJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDICAL_SCRIBE_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, MEDICAL_SCRIBE_JOB_STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String medicalScribeJobName;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant completionTime;
    private final String languageCode;
    private final String medicalScribeJobStatus;
    private final String failureReason;

    private MedicalScribeJobSummary(BuilderImpl builder) {
        this.medicalScribeJobName = builder.medicalScribeJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.medicalScribeJobStatus = builder.medicalScribeJobStatus;
        this.failureReason = builder.failureReason;
    }

    public final String medicalScribeJobName() {
        return this.medicalScribeJobName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final MedicalScribeLanguageCode languageCode() {
        return MedicalScribeLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final MedicalScribeJobStatus medicalScribeJobStatus() {
        return MedicalScribeJobStatus.fromValue(this.medicalScribeJobStatus);
    }

    public final String medicalScribeJobStatusAsString() {
        return this.medicalScribeJobStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.medicalScribeJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeJobSummary)) {
            return false;
        }
        MedicalScribeJobSummary other = (MedicalScribeJobSummary)obj;
        return Objects.equals(this.medicalScribeJobName(), other.medicalScribeJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.medicalScribeJobStatusAsString(), other.medicalScribeJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeJobSummary").add("MedicalScribeJobName", (Object)this.medicalScribeJobName()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MedicalScribeJobStatus", (Object)this.medicalScribeJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MedicalScribeJobName": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MedicalScribeJobStatus": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MedicalScribeJobName", MEDICAL_SCRIBE_JOB_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("MedicalScribeJobStatus", MEDICAL_SCRIBE_JOB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeJobSummary, T> g) {
        return obj -> g.apply((MedicalScribeJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String medicalScribeJobName;
        private Instant creationTime;
        private Instant startTime;
        private Instant completionTime;
        private String languageCode;
        private String medicalScribeJobStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeJobSummary model) {
            this.medicalScribeJobName(model.medicalScribeJobName);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.languageCode(model.languageCode);
            this.medicalScribeJobStatus(model.medicalScribeJobStatus);
            this.failureReason(model.failureReason);
        }

        public final String getMedicalScribeJobName() {
            return this.medicalScribeJobName;
        }

        public final void setMedicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
        }

        @Override
        public final Builder medicalScribeJobName(String medicalScribeJobName) {
            this.medicalScribeJobName = medicalScribeJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(MedicalScribeLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getMedicalScribeJobStatus() {
            return this.medicalScribeJobStatus;
        }

        public final void setMedicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
        }

        @Override
        public final Builder medicalScribeJobStatus(String medicalScribeJobStatus) {
            this.medicalScribeJobStatus = medicalScribeJobStatus;
            return this;
        }

        @Override
        public final Builder medicalScribeJobStatus(MedicalScribeJobStatus medicalScribeJobStatus) {
            this.medicalScribeJobStatus(medicalScribeJobStatus == null ? null : medicalScribeJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public MedicalScribeJobSummary build() {
            return new MedicalScribeJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeJobSummary> {
        public Builder medicalScribeJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(MedicalScribeLanguageCode var1);

        public Builder medicalScribeJobStatus(String var1);

        public Builder medicalScribeJobStatus(MedicalScribeJobStatus var1);

        public Builder failureReason(String var1);
    }
}

