/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BaseModelName {
    NARROW_BAND("NarrowBand"),
    WIDE_BAND("WideBand"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BaseModelName> VALUE_MAP;
    private final String value;

    private BaseModelName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BaseModelName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BaseModelName> knownValues() {
        EnumSet<BaseModelName> knownValues = EnumSet.allOf(BaseModelName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BaseModelName.class, BaseModelName::toString);
    }
}

