/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Media
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Media> {
    private static final SdkField<String> MEDIA_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaFileUri").getter(Media.getter(Media::mediaFileUri)).setter(Media.setter(Builder::mediaFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFileUri").build()}).build();
    private static final SdkField<String> REDACTED_MEDIA_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedactedMediaFileUri").getter(Media.getter(Media::redactedMediaFileUri)).setter(Media.setter(Builder::redactedMediaFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedactedMediaFileUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_FILE_URI_FIELD, REDACTED_MEDIA_FILE_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Media.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaFileUri;
    private final String redactedMediaFileUri;

    private Media(BuilderImpl builder) {
        this.mediaFileUri = builder.mediaFileUri;
        this.redactedMediaFileUri = builder.redactedMediaFileUri;
    }

    public final String mediaFileUri() {
        return this.mediaFileUri;
    }

    public final String redactedMediaFileUri() {
        return this.redactedMediaFileUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.redactedMediaFileUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Media)) {
            return false;
        }
        Media other = (Media)obj;
        return Objects.equals(this.mediaFileUri(), other.mediaFileUri()) && Objects.equals(this.redactedMediaFileUri(), other.redactedMediaFileUri());
    }

    public final String toString() {
        return ToString.builder((String)"Media").add("MediaFileUri", (Object)this.mediaFileUri()).add("RedactedMediaFileUri", (Object)this.redactedMediaFileUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaFileUri": {
                return Optional.ofNullable(clazz.cast(this.mediaFileUri()));
            }
            case "RedactedMediaFileUri": {
                return Optional.ofNullable(clazz.cast(this.redactedMediaFileUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MediaFileUri", MEDIA_FILE_URI_FIELD);
        map.put("RedactedMediaFileUri", REDACTED_MEDIA_FILE_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Media, T> g) {
        return obj -> g.apply((Media)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaFileUri;
        private String redactedMediaFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Media model) {
            this.mediaFileUri(model.mediaFileUri);
            this.redactedMediaFileUri(model.redactedMediaFileUri);
        }

        public final String getMediaFileUri() {
            return this.mediaFileUri;
        }

        public final void setMediaFileUri(String mediaFileUri) {
            this.mediaFileUri = mediaFileUri;
        }

        @Override
        public final Builder mediaFileUri(String mediaFileUri) {
            this.mediaFileUri = mediaFileUri;
            return this;
        }

        public final String getRedactedMediaFileUri() {
            return this.redactedMediaFileUri;
        }

        public final void setRedactedMediaFileUri(String redactedMediaFileUri) {
            this.redactedMediaFileUri = redactedMediaFileUri;
        }

        @Override
        public final Builder redactedMediaFileUri(String redactedMediaFileUri) {
            this.redactedMediaFileUri = redactedMediaFileUri;
            return this;
        }

        public Media build() {
            return new Media(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Media> {
        public Builder mediaFileUri(String var1);

        public Builder redactedMediaFileUri(String var1);
    }
}

