/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobDetails;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsJobSummary> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAnalyticsJobName").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::callAnalyticsJobName)).setter(CallAnalyticsJobSummary.setter(Builder::callAnalyticsJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::creationTime)).setter(CallAnalyticsJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::startTime)).setter(CallAnalyticsJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::completionTime)).setter(CallAnalyticsJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::languageCodeAsString)).setter(CallAnalyticsJobSummary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> CALL_ANALYTICS_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAnalyticsJobStatus").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::callAnalyticsJobStatusAsString)).setter(CallAnalyticsJobSummary.setter(Builder::callAnalyticsJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobStatus").build()}).build();
    private static final SdkField<CallAnalyticsJobDetails> CALL_ANALYTICS_JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallAnalyticsJobDetails").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::callAnalyticsJobDetails)).setter(CallAnalyticsJobSummary.setter(Builder::callAnalyticsJobDetails)).constructor(CallAnalyticsJobDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobDetails").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(CallAnalyticsJobSummary.getter(CallAnalyticsJobSummary::failureReason)).setter(CallAnalyticsJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, CALL_ANALYTICS_JOB_STATUS_FIELD, CALL_ANALYTICS_JOB_DETAILS_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CallAnalyticsJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String callAnalyticsJobName;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant completionTime;
    private final String languageCode;
    private final String callAnalyticsJobStatus;
    private final CallAnalyticsJobDetails callAnalyticsJobDetails;
    private final String failureReason;

    private CallAnalyticsJobSummary(BuilderImpl builder) {
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.callAnalyticsJobStatus = builder.callAnalyticsJobStatus;
        this.callAnalyticsJobDetails = builder.callAnalyticsJobDetails;
        this.failureReason = builder.failureReason;
    }

    public final String callAnalyticsJobName() {
        return this.callAnalyticsJobName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final CallAnalyticsJobStatus callAnalyticsJobStatus() {
        return CallAnalyticsJobStatus.fromValue(this.callAnalyticsJobStatus);
    }

    public final String callAnalyticsJobStatusAsString() {
        return this.callAnalyticsJobStatus;
    }

    public final CallAnalyticsJobDetails callAnalyticsJobDetails() {
        return this.callAnalyticsJobDetails;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAnalyticsJobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJobSummary)) {
            return false;
        }
        CallAnalyticsJobSummary other = (CallAnalyticsJobSummary)obj;
        return Objects.equals(this.callAnalyticsJobName(), other.callAnalyticsJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.callAnalyticsJobStatusAsString(), other.callAnalyticsJobStatusAsString()) && Objects.equals(this.callAnalyticsJobDetails(), other.callAnalyticsJobDetails()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsJobSummary").add("CallAnalyticsJobName", (Object)this.callAnalyticsJobName()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("CallAnalyticsJobStatus", (Object)this.callAnalyticsJobStatusAsString()).add("CallAnalyticsJobDetails", (Object)this.callAnalyticsJobDetails()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallAnalyticsJobName": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "CallAnalyticsJobStatus": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobStatusAsString()));
            }
            case "CallAnalyticsJobDetails": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobDetails()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CallAnalyticsJobName", CALL_ANALYTICS_JOB_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("CallAnalyticsJobStatus", CALL_ANALYTICS_JOB_STATUS_FIELD);
        map.put("CallAnalyticsJobDetails", CALL_ANALYTICS_JOB_DETAILS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsJobSummary, T> g) {
        return obj -> g.apply((CallAnalyticsJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callAnalyticsJobName;
        private Instant creationTime;
        private Instant startTime;
        private Instant completionTime;
        private String languageCode;
        private String callAnalyticsJobStatus;
        private CallAnalyticsJobDetails callAnalyticsJobDetails;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsJobSummary model) {
            this.callAnalyticsJobName(model.callAnalyticsJobName);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.languageCode(model.languageCode);
            this.callAnalyticsJobStatus(model.callAnalyticsJobStatus);
            this.callAnalyticsJobDetails(model.callAnalyticsJobDetails);
            this.failureReason(model.failureReason);
        }

        public final String getCallAnalyticsJobName() {
            return this.callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getCallAnalyticsJobStatus() {
            return this.callAnalyticsJobStatus;
        }

        public final void setCallAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
        }

        @Override
        public final Builder callAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
            return this;
        }

        @Override
        public final Builder callAnalyticsJobStatus(CallAnalyticsJobStatus callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus(callAnalyticsJobStatus == null ? null : callAnalyticsJobStatus.toString());
            return this;
        }

        public final CallAnalyticsJobDetails.Builder getCallAnalyticsJobDetails() {
            return this.callAnalyticsJobDetails != null ? this.callAnalyticsJobDetails.toBuilder() : null;
        }

        public final void setCallAnalyticsJobDetails(CallAnalyticsJobDetails.BuilderImpl callAnalyticsJobDetails) {
            this.callAnalyticsJobDetails = callAnalyticsJobDetails != null ? callAnalyticsJobDetails.build() : null;
        }

        @Override
        public final Builder callAnalyticsJobDetails(CallAnalyticsJobDetails callAnalyticsJobDetails) {
            this.callAnalyticsJobDetails = callAnalyticsJobDetails;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public CallAnalyticsJobSummary build() {
            return new CallAnalyticsJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsJobSummary> {
        public Builder callAnalyticsJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder callAnalyticsJobStatus(String var1);

        public Builder callAnalyticsJobStatus(CallAnalyticsJobStatus var1);

        public Builder callAnalyticsJobDetails(CallAnalyticsJobDetails var1);

        default public Builder callAnalyticsJobDetails(Consumer<CallAnalyticsJobDetails.Builder> callAnalyticsJobDetails) {
            return this.callAnalyticsJobDetails((CallAnalyticsJobDetails)((CallAnalyticsJobDetails.Builder)CallAnalyticsJobDetails.builder().applyMutation(callAnalyticsJobDetails)).build());
        }

        public Builder failureReason(String var1);
    }
}

